/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.config;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jolokia.server.core.config.ConfigExtractor;

public class MapConfigExtractor
implements ConfigExtractor {
    private final Map<String, String> properties;
    private final Predicate<String> acceptsKey;

    public MapConfigExtractor(Map<String, String> properties) {
        this.properties = properties;
        this.acceptsKey = key -> true;
    }

    public MapConfigExtractor(Map<String, String> properties, Predicate<String> acceptsKey) {
        this.properties = properties;
        this.acceptsKey = acceptsKey;
    }

    @Override
    public Enumeration<String> getNames() {
        return Collections.enumeration(this.properties.keySet().stream().filter(this.acceptsKey).collect(Collectors.toList()));
    }

    @Override
    public String getParameter(String key) {
        return this.acceptsKey.test(key) ? this.properties.get(key) : null;
    }
}

