/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import org.apache.camel.RuntimeCamelException;
import org.apache.camel.util.URISupport;

public class FailedToCreateRouteException
extends RuntimeCamelException {
    private final String routeId;
    private final String location;

    public FailedToCreateRouteException(String cause) {
        super("Failed to create route because: " + cause);
        this.routeId = null;
        this.location = null;
    }

    public FailedToCreateRouteException(String routeId, String location, String route, String cause) {
        super("Failed to create route: " + routeId + (String)(location != null ? " (source: " + location + ")" : "") + ": " + FailedToCreateRouteException.getRouteMessage(route) + " because: " + cause);
        this.routeId = routeId;
        this.location = location;
    }

    public FailedToCreateRouteException(String routeId, String location, String route, Throwable cause) {
        super("Failed to create route: " + routeId + (String)(location != null ? " (source: " + location + ")" : "") + ": " + FailedToCreateRouteException.getRouteMessage(route) + " because: " + FailedToCreateRouteException.getExceptionMessage(cause), cause);
        this.routeId = routeId;
        this.location = location;
    }

    public FailedToCreateRouteException(String routeId, String location, String route, String at, Throwable cause) {
        super("Failed to create route: " + routeId + (String)(location != null ? " (source: " + location + ")" : "") + " at: >>> " + at + " <<< in route: " + FailedToCreateRouteException.getRouteMessage(route) + " because: " + FailedToCreateRouteException.getExceptionMessage(cause), cause);
        this.routeId = routeId;
        this.location = location;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public String getLocation() {
        return this.location;
    }

    protected static String getExceptionMessage(Throwable cause) {
        return cause.getMessage() != null ? cause.getMessage() : cause.getClass().getSimpleName();
    }

    protected static String getRouteMessage(String route) {
        if (((String)route).length() > 60) {
            route = ((String)route).substring(0, 60) + "...";
        }
        route = URISupport.sanitizeUri((String)route);
        return route;
    }
}

