/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.log;

import java.util.Locale;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.log.LogEndpoint;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.LoggerHelper;
import org.apache.camel.support.processor.DefaultExchangeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.apache.camel.spi.annotations.Component(value="log")
public class LogComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(LogComponent.class);
    private ExchangeFormatter defaultExchangeFormatter;
    @Metadata(label="advanced", autowired=true)
    private ExchangeFormatter exchangeFormatter;
    @Metadata
    private boolean sourceLocationLoggerName;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        ExchangeFormatter logFormatter;
        LoggingLevel level = this.getLoggingLevel(parameters);
        Logger providedLogger = this.getLogger(parameters);
        if (providedLogger == null) {
            Map availableLoggers = this.getCamelContext().getRegistry().findByTypeWithName(Logger.class);
            if (availableLoggers.size() == 1) {
                providedLogger = (Logger)availableLoggers.values().iterator().next();
                LOG.info("Using custom Logger: {}", (Object)providedLogger);
            } else if (availableLoggers.size() > 1) {
                LOG.info("More than one {} instance found in the registry. Falling back to creating logger from URI {}.", (Object)Logger.class.getName(), (Object)uri);
            }
        }
        if ((logFormatter = (ExchangeFormatter)this.getCamelContext().getRegistry().lookupByNameAndType("logFormatter", ExchangeFormatter.class)) != null) {
            this.setProperties(logFormatter, parameters);
        } else if (this.exchangeFormatter != null) {
            logFormatter = this.exchangeFormatter;
        }
        LogEndpoint endpoint = new LogEndpoint(uri, (Component)this);
        endpoint.setLevel(level.name());
        endpoint.setSourceLocationLoggerName(this.sourceLocationLoggerName);
        endpoint.setExchangeFormatter(logFormatter);
        this.setProperties((Endpoint)endpoint, parameters);
        if (providedLogger == null) {
            String loggerName;
            String string = loggerName = endpoint.isSourceLocationLoggerName() ? LoggerHelper.getLineNumberLoggerName((Object)((Object)endpoint)) : null;
            if (loggerName == null) {
                loggerName = remaining;
            }
            endpoint.setLoggerName(loggerName);
        } else {
            endpoint.setProvidedLogger(providedLogger);
        }
        return endpoint;
    }

    protected LoggingLevel getLoggingLevel(Map<String, Object> parameters) {
        String levelText = (String)this.getAndRemoveParameter(parameters, "level", String.class);
        if (levelText != null) {
            return LoggingLevel.valueOf((String)levelText.toUpperCase(Locale.ENGLISH));
        }
        return LoggingLevel.INFO;
    }

    protected Logger getLogger(Map<String, Object> parameters) {
        return (Logger)this.getAndRemoveOrResolveReferenceParameter(parameters, "logger", Logger.class);
    }

    public ExchangeFormatter getExchangeFormatter() {
        return this.exchangeFormatter;
    }

    public void setExchangeFormatter(ExchangeFormatter exchangeFormatter) {
        this.exchangeFormatter = exchangeFormatter;
    }

    public boolean isSourceLocationLoggerName() {
        return this.sourceLocationLoggerName;
    }

    public void setSourceLocationLoggerName(boolean sourceLocationLoggerName) {
        this.sourceLocationLoggerName = sourceLocationLoggerName;
    }

    public ExchangeFormatter getDefaultExchangeFormatter() {
        return this.defaultExchangeFormatter;
    }

    protected void doInit() throws Exception {
        DefaultExchangeFormatter def = new DefaultExchangeFormatter();
        def.setShowExchangePattern(true);
        def.setSkipBodyLineSeparator(true);
        def.setShowBody(true);
        def.setShowBodyType(true);
        def.setStyle(DefaultExchangeFormatter.OutputStyle.Default);
        def.setMaxChars(10000);
        this.defaultExchangeFormatter = def;
    }
}

