# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

# NOTE! THIS FILE IS AUTOMATICALLY GENERATED AND WILL BE OVERWRITTEN!
#
# IF YOU WANT TO MODIFY THIS FILE, YOU SHOULD MODIFY THE TEMPLATE
# `get_provider_info_TEMPLATE.py.jinja2` IN the `dev/breeze/src/airflow_breeze/templates` DIRECTORY


def get_provider_info():
    return {
        "package-name": "apache-airflow-providers-postgres",
        "name": "PostgreSQL",
        "description": "`PostgreSQL <https://www.postgresql.org/>`__\n",
        "integrations": [
            {
                "integration-name": "PostgreSQL",
                "external-doc-url": "https://www.postgresql.org/",
                "how-to-guide": ["/docs/apache-airflow-providers-postgres/operators.rst"],
                "logo": "/docs/integration-logos/Postgres.png",
                "tags": ["software"],
            }
        ],
        "dialects": [
            {
                "dialect-type": "postgresql",
                "dialect-class-name": "airflow.providers.postgres.dialects.postgres.PostgresDialect",
            }
        ],
        "hooks": [
            {
                "integration-name": "PostgreSQL",
                "python-modules": ["airflow.providers.postgres.hooks.postgres"],
            }
        ],
        "connection-types": [
            {
                "hook-class-name": "airflow.providers.postgres.hooks.postgres.PostgresHook",
                "connection-type": "postgres",
            }
        ],
        "asset-uris": [
            {
                "schemes": ["postgres", "postgresql"],
                "handler": "airflow.providers.postgres.assets.postgres.sanitize_uri",
            }
        ],
        "dataset-uris": [
            {
                "schemes": ["postgres", "postgresql"],
                "handler": "airflow.providers.postgres.assets.postgres.sanitize_uri",
            }
        ],
        "config": {
            "postgres": {
                "description": "Configuration for Postgres hooks and operators.\n",
                "options": {
                    "azure_oauth_scope": {
                        "description": "The scope to use while retrieving Oauth token for Postgres Flexible Server\nfrom Azure Entra authentication.\n",
                        "version_added": "6.4.0",
                        "type": "string",
                        "example": None,
                        "default": "https://ossrdbms-aad.database.windows.net/.default",
                    }
                },
            }
        },
    }
