/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.http.server;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpRequestAggregator
extends HttpObjectAggregator {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final FullHttpResponse TOO_LARGE_CLOSE = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, Unpooled.EMPTY_BUFFER);
    private boolean failed = false;

    public HttpRequestAggregator(int maxContentLength) {
        super(maxContentLength);
    }

    public HttpRequestAggregator(int maxContentLength, boolean closeOnExpectationFailed) {
        super(maxContentLength, closeOnExpectationFailed);
    }

    protected void decode(ChannelHandlerContext ctx, HttpObject msg, List<Object> out) throws Exception {
        if (!this.failed) {
            super.decode(ctx, (Object)msg, out);
        }
    }

    protected void handleOversizedMessage(ChannelHandlerContext ctx, HttpMessage oversized) throws Exception {
        this.failed = true;
        LOGGER.warn("A large request encountered. Closing the channel");
        if (!(oversized instanceof HttpRequest)) {
            throw new IllegalStateException("Unknown large message of class " + oversized.getClass());
        }
        ChannelFuture future = ctx.writeAndFlush((Object)TOO_LARGE_CLOSE.retainedDuplicate());
        future.addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
            if (!channelFuture.isSuccess()) {
                LOGGER.debug("Failed to send a 413 Request Entity Too Large.", channelFuture.cause());
            }
            ctx.close();
        }));
    }
}

