/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.CompactionManagerMBean;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;
import org.apache.cassandra.tools.nodetool.formatter.TableBuilder;

@Command(name="compactionstats", description="Print statistics on compactions")
public class CompactionStats
extends NodeTool.NodeToolCmd {
    @Option(title="human_readable", name={"-H", "--human-readable"}, description="Display bytes in human readable form, i.e. KB, MB, GB, TB")
    private boolean humanReadable = false;

    @Override
    public void execute(NodeProbe probe) {
        PrintStream out = probe.output().out;
        CompactionManagerMBean cm = probe.getCompactionManagerProxy();
        out.println("pending tasks: " + probe.getCompactionMetric("PendingTasks"));
        long remainingBytes = 0L;
        TableBuilder table = new TableBuilder();
        List<Map<String, String>> compactions = cm.getCompactions();
        if (!compactions.isEmpty()) {
            int compactionThroughput = probe.getCompactionThroughput();
            table.add("id", "compaction type", "keyspace", "table", "completed", "total", "unit", "progress");
            for (Map<String, String> c : compactions) {
                long total = Long.parseLong(c.get("total"));
                long completed = Long.parseLong(c.get("completed"));
                String taskType = c.get("taskType");
                String keyspace = c.get("keyspace");
                String columnFamily = c.get("columnfamily");
                String unit = c.get("unit");
                boolean toFileSize = this.humanReadable && CompactionInfo.Unit.isFileSize(unit);
                String completedStr = toFileSize ? FileUtils.stringifyFileSize(completed) : Long.toString(completed);
                String totalStr = toFileSize ? FileUtils.stringifyFileSize(total) : Long.toString(total);
                String percentComplete = total == 0L ? "n/a" : new DecimalFormat("0.00").format((double)completed / (double)total * 100.0) + "%";
                String id = c.get("compactionId");
                table.add(id, taskType, keyspace, columnFamily, completedStr, totalStr, unit, percentComplete);
                remainingBytes += total - completed;
            }
            table.printTo(out);
            String remainingTime = "n/a";
            if (compactionThroughput != 0) {
                long remainingTimeInSecs = remainingBytes / (0x100000L * (long)compactionThroughput);
                remainingTime = String.format("%dh%02dm%02ds", remainingTimeInSecs / 3600L, remainingTimeInSecs % 3600L / 60L, remainingTimeInSecs % 60L);
            }
            out.printf("%25s%10s%n", "Active compaction remaining time : ", remainingTime);
        }
    }
}

