/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.UUIDSerializer;

public class TimeUUIDSerializer
extends UUIDSerializer {
    public static final TimeUUIDSerializer instance = new TimeUUIDSerializer();

    @Override
    public <V> void validate(V value, ValueAccessor<V> accessor) throws MarshalException {
        super.validate(value, accessor);
        if (!accessor.isEmpty(value) && (accessor.getByte(value, 6) & 0xF0) != 16) {
            throw new MarshalException("Invalid version for TimeUUID type.");
        }
    }
}

