/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.operations.userdefined;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TableMetadata;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.stress.Operation;
import org.apache.cassandra.stress.generate.Distribution;
import org.apache.cassandra.stress.generate.DistributionFixed;
import org.apache.cassandra.stress.generate.PartitionGenerator;
import org.apache.cassandra.stress.generate.PartitionIterator;
import org.apache.cassandra.stress.generate.Row;
import org.apache.cassandra.stress.generate.Seed;
import org.apache.cassandra.stress.generate.SeedManager;
import org.apache.cassandra.stress.operations.PartitionOperation;
import org.apache.cassandra.stress.report.Timer;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.cassandra.stress.util.JavaDriverClient;
import org.apache.cassandra.utils.Pair;

public class ValidatingSchemaQuery
extends PartitionOperation {
    private Pair<Row, Row> bounds;
    final int clusteringComponents;
    final ValidatingStatement[] statements;
    final ConsistencyLevel cl;
    final int[] argumentIndex;
    final Object[] bindBuffer;

    private ValidatingSchemaQuery(Timer timer, StressSettings settings, PartitionGenerator generator, SeedManager seedManager, ValidatingStatement[] statements, ConsistencyLevel cl, int clusteringComponents) {
        super(timer, settings, new PartitionOperation.DataSpec(generator, seedManager, (Distribution)new DistributionFixed(1L), settings.insert.rowPopulationRatio.get(), 1));
        this.statements = statements;
        this.cl = cl;
        this.argumentIndex = new int[statements[0].statement.getVariables().size()];
        this.bindBuffer = new Object[this.argumentIndex.length];
        int i = 0;
        for (ColumnDefinitions.Definition definition : statements[0].statement.getVariables()) {
            this.argumentIndex[i++] = this.spec.partitionGenerator.indexOf(definition.getName());
        }
        for (ValidatingStatement statement : statements) {
            if (cl.isSerialConsistency()) {
                statement.statement.setSerialConsistencyLevel(JavaDriverClient.from(cl));
                continue;
            }
            statement.statement.setConsistencyLevel(JavaDriverClient.from(cl));
        }
        this.clusteringComponents = clusteringComponents;
    }

    @Override
    protected boolean reset(Seed seed, PartitionIterator iterator) {
        this.bounds = iterator.resetToBounds(seed, this.clusteringComponents);
        return true;
    }

    BoundStatement bind(int statementIndex) {
        int pkc = ((Row)this.bounds.left).partitionKey.length;
        System.arraycopy(((Row)this.bounds.left).partitionKey, 0, this.bindBuffer, 0, pkc);
        int ccc = ((Row)this.bounds.left).row.length;
        System.arraycopy(((Row)this.bounds.left).row, 0, this.bindBuffer, pkc, ccc);
        System.arraycopy(((Row)this.bounds.right).row, 0, this.bindBuffer, pkc + ccc, ccc);
        return this.statements[statementIndex].statement.bind(this.bindBuffer);
    }

    @Override
    public void run(JavaDriverClient client) throws IOException {
        this.timeWithRetry(new JavaDriverRun(client, (PartitionIterator)this.partitions.get(0)));
    }

    public static List<Factory> create(TableMetadata metadata, StressSettings settings) {
        ArrayList<Factory> factories = new ArrayList<Factory>();
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        sb.append("SELECT * FROM ");
        sb.append(metadata.getName());
        sb.append(" WHERE");
        for (ColumnMetadata pk : metadata.getPartitionKey()) {
            sb.append(first ? " " : " AND ");
            sb.append(pk.getName());
            sb.append(" = ?");
            first = false;
        }
        String base = sb.toString();
        factories.add(new Factory(new ValidatingStatement[]{ValidatingSchemaQuery.prepare(settings, base, true, true)}, 0));
        int maxDepth = metadata.getClusteringColumns().size() - 1;
        for (int depth = 0; depth <= maxDepth; ++depth) {
            boolean[] blArray;
            StringBuilder cc = new StringBuilder();
            StringBuilder arg = new StringBuilder();
            cc.append('(');
            arg.append('(');
            for (int d = 0; d <= depth; ++d) {
                if (d > 0) {
                    cc.append(',');
                    arg.append(',');
                }
                cc.append(((ColumnMetadata)metadata.getClusteringColumns().get(d)).getName());
                arg.append('?');
            }
            cc.append(')');
            arg.append(')');
            ValidatingStatement[] statements = new ValidatingStatement[depth < maxDepth ? 1 : 4];
            int i = 0;
            if (depth < maxDepth) {
                boolean[] blArray2 = new boolean[1];
                blArray = blArray2;
                blArray2[0] = true;
            } else {
                boolean[] blArray3 = new boolean[2];
                blArray3[0] = true;
                blArray = blArray3;
                blArray3[1] = false;
            }
            for (boolean incLb : blArray) {
                boolean[] blArray4;
                if (depth < maxDepth) {
                    boolean[] blArray5 = new boolean[1];
                    blArray4 = blArray5;
                    blArray5[0] = false;
                } else {
                    boolean[] blArray6 = new boolean[2];
                    blArray6[0] = true;
                    blArray4 = blArray6;
                    blArray6[1] = false;
                }
                for (boolean incUb : blArray4) {
                    String lb = incLb ? ">=" : ">";
                    String ub = incUb ? "<=" : "<";
                    sb.setLength(0);
                    sb.append(base);
                    sb.append(" AND ");
                    sb.append((CharSequence)cc);
                    sb.append(lb);
                    sb.append((CharSequence)arg);
                    sb.append(" AND ");
                    sb.append((CharSequence)cc);
                    sb.append(ub);
                    sb.append((CharSequence)arg);
                    statements[i++] = ValidatingSchemaQuery.prepare(settings, sb.toString(), incLb, incUb);
                }
            }
            factories.add(new Factory(statements, depth + 1));
        }
        return factories;
    }

    private static ValidatingStatement prepare(StressSettings settings, String cql, boolean incLb, boolean incUb) {
        JavaDriverClient jclient = settings.getJavaDriverClient();
        PreparedStatement statement = jclient.prepare(cql);
        return new ValidatingStatement(statement, incLb, incUb);
    }

    private static class ValidatingStatement {
        final PreparedStatement statement;
        final boolean inclusiveStart;
        final boolean inclusiveEnd;

        private ValidatingStatement(PreparedStatement statement, boolean inclusiveStart, boolean inclusiveEnd) {
            this.statement = statement;
            this.inclusiveStart = inclusiveStart;
            this.inclusiveEnd = inclusiveEnd;
        }
    }

    public static class Factory {
        final ValidatingStatement[] statements;
        final int clusteringComponents;

        public Factory(ValidatingStatement[] statements, int clusteringComponents) {
            this.statements = statements;
            this.clusteringComponents = clusteringComponents;
        }

        public ValidatingSchemaQuery create(Timer timer, StressSettings settings, PartitionGenerator generator, SeedManager seedManager, ConsistencyLevel cl) {
            return new ValidatingSchemaQuery(timer, settings, generator, seedManager, this.statements, cl, this.clusteringComponents);
        }
    }

    private class JavaDriverRun
    extends Runner {
        final JavaDriverClient client;

        private JavaDriverRun(JavaDriverClient client, PartitionIterator iter) {
            super(iter);
            this.client = client;
        }

        @Override
        public boolean run() throws Exception {
            ResultSet rs = this.client.getSession().execute((Statement)ValidatingSchemaQuery.this.bind(this.statementIndex));
            int[] valueIndex = new int[rs.getColumnDefinitions().size()];
            int i = 0;
            for (ColumnDefinitions.Definition definition : rs.getColumnDefinitions()) {
                valueIndex[i++] = ((ValidatingSchemaQuery)ValidatingSchemaQuery.this).spec.partitionGenerator.indexOf(definition.getName());
            }
            this.rowCount = 0;
            Iterator results = rs.iterator();
            if (!ValidatingSchemaQuery.this.statements[this.statementIndex].inclusiveStart && this.iter.hasNext()) {
                this.iter.next();
            }
            while (this.iter.hasNext()) {
                Row expectedRow = (Row)this.iter.next();
                if (!ValidatingSchemaQuery.this.statements[this.statementIndex].inclusiveEnd && !this.iter.hasNext()) break;
                if (!results.hasNext()) {
                    return false;
                }
                ++this.rowCount;
                com.datastax.driver.core.Row actualRow = (com.datastax.driver.core.Row)results.next();
                for (int i2 = 0; i2 < actualRow.getColumnDefinitions().size(); ++i2) {
                    Object actualValue;
                    Object expectedValue = expectedRow.get(valueIndex[i2]);
                    if (expectedValue.equals(actualValue = ((ValidatingSchemaQuery)ValidatingSchemaQuery.this).spec.partitionGenerator.convert(valueIndex[i2], actualRow.getBytesUnsafe(i2)))) continue;
                    return false;
                }
            }
            this.partitionCount = Math.min(1, this.rowCount);
            return rs.isExhausted();
        }
    }

    abstract class Runner
    implements Operation.RunOp {
        int partitionCount;
        int rowCount;
        final PartitionIterator iter;
        final int statementIndex;

        protected Runner(PartitionIterator iter) {
            this.iter = iter;
            this.statementIndex = ThreadLocalRandom.current().nextInt(ValidatingSchemaQuery.this.statements.length);
        }

        @Override
        public int partitionCount() {
            return this.partitionCount;
        }

        @Override
        public int rowCount() {
            return this.rowCount;
        }
    }
}

