/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.lab.jvm.attach;

import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import org.gridkit.lab.jvm.attach.LogStream;

class AttachAPI {
    private static final LogStream LOG_ERROR = LogStream.error();
    private static boolean started;

    AttachAPI() {
    }

    public static void ensureToolsJar() {
        if (!started) {
            LOG_ERROR.log("Attach API not initialized");
        }
    }

    static {
        try {
            if (ClassLoader.getSystemClassLoader() instanceof URLClassLoader) {
                String javaHome = System.getProperty("java.home");
                String toolsJarURL = "file:" + javaHome + "/../lib/tools.jar";
                Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                method.setAccessible(true);
                URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
                if (sysloader.getResourceAsStream("/com/sun/tools/attach/VirtualMachine.class") == null) {
                    method.invoke((Object)sysloader, new URL(toolsJarURL));
                    Thread.currentThread().getContextClassLoader().loadClass("com.sun.tools.attach.VirtualMachine");
                    Thread.currentThread().getContextClassLoader().loadClass("com.sun.tools.attach.AttachNotSupportedException");
                }
            } else {
                Thread.currentThread().getContextClassLoader().loadClass("com.sun.tools.attach.VirtualMachine");
                Thread.currentThread().getContextClassLoader().loadClass("com.sun.tools.attach.AttachNotSupportedException");
            }
        }
        catch (Exception e) {
            LOG_ERROR.log("Java home points to " + System.getProperty("java.home") + " make sure it is not a JRE path");
            LOG_ERROR.log("Failed to add tools.jar to classpath", e);
        }
        started = true;
    }
}

