/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.dbload;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.dbsync.naming.NameBuilder;
import org.apache.cayenne.dbsync.naming.ObjectNameGenerator;
import org.apache.cayenne.dbsync.reverse.dbload.AbstractLoader;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoadDataStore;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoader;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoaderConfiguration;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoaderDelegate;
import org.apache.cayenne.dbsync.reverse.dbload.DbRelationshipDetected;
import org.apache.cayenne.dbsync.reverse.dbload.ExportedKey;
import org.apache.cayenne.dbsync.reverse.filters.TableFilter;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationshipLoader
extends AbstractLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbLoader.class);
    private final ObjectNameGenerator nameGenerator;

    RelationshipLoader(DbLoaderConfiguration config, DbLoaderDelegate delegate, ObjectNameGenerator nameGenerator) {
        super(null, config, delegate);
        this.nameGenerator = nameGenerator;
    }

    @Override
    public void load(DatabaseMetaData metaData, DbLoadDataStore map) throws SQLException {
        if (this.config.isSkipRelationshipsLoading()) {
            return;
        }
        for (Map.Entry<String, Set<ExportedKey>> entry : map.getExportedKeysEntrySet()) {
            Set<ExportedKey> exportedKeys;
            ExportedKey key;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Process keys for: " + entry.getKey());
            }
            if ((key = (exportedKeys = entry.getValue()).iterator().next()) == null) {
                throw new IllegalStateException();
            }
            ExportedKey.KeyData PK = key.getPk();
            ExportedKey.KeyData FK = key.getFk();
            DbEntity pkEntity = map.getDbEntity(PK.getTable());
            DbEntity fkEntity = map.getDbEntity(FK.getTable());
            if (pkEntity == null || fkEntity == null) {
                throw new IllegalStateException();
            }
            DbRelationship forwardRelationship = new DbRelationship();
            forwardRelationship.setSourceEntity((Entity)pkEntity);
            forwardRelationship.setTargetEntityName((Entity)fkEntity);
            DbRelationshipDetected reverseRelationship = new DbRelationshipDetected();
            reverseRelationship.setFkName(FK.getName());
            reverseRelationship.setSourceEntity((Entity)fkEntity);
            reverseRelationship.setTargetEntityName((Entity)pkEntity);
            reverseRelationship.setToMany(false);
            this.createAndAppendJoins(exportedKeys, pkEntity, fkEntity, forwardRelationship, reverseRelationship);
            boolean toDependentPK = this.isToDependentPK(forwardRelationship);
            boolean toMany = this.isToMany(toDependentPK, fkEntity, forwardRelationship);
            forwardRelationship.setToDependentPK(toDependentPK);
            forwardRelationship.setToMany(toMany);
            this.setRelationshipName(pkEntity, forwardRelationship);
            this.setRelationshipName(fkEntity, reverseRelationship);
            this.checkAndAddRelationship(pkEntity, forwardRelationship);
            this.checkAndAddRelationship(fkEntity, reverseRelationship);
        }
    }

    private void setRelationshipName(DbEntity entity, DbRelationship relationship) {
        relationship.setName(NameBuilder.builder((ConfigurationNode)relationship, (ConfigurationNode)entity).baseName(this.nameGenerator.relationshipName(relationship)).name());
    }

    private void checkAndAddRelationship(DbEntity entity, DbRelationship relationship) {
        TableFilter sourceTableFilter = this.config.getFiltersConfig().tableFilter(relationship.getSourceEntity().getCatalog(), relationship.getSourceEntity().getSchema());
        TableFilter targetTableFilter = this.config.getFiltersConfig().tableFilter(relationship.getTargetEntity().getCatalog(), relationship.getTargetEntity().getSchema());
        if (sourceTableFilter != null && !sourceTableFilter.getIncludeTableRelationshipFilter(entity.getName()).isIncluded(relationship.getName())) {
            return;
        }
        if (relationship.getJoins().isEmpty()) {
            return;
        }
        if (sourceTableFilter != null && targetTableFilter != null) {
            for (DbJoin join : relationship.getJoins()) {
                if (sourceTableFilter.getIncludeTableColumnFilter(entity.getName()).isIncluded(join.getSourceName()) && targetTableFilter.getIncludeTableColumnFilter(relationship.getTargetEntityName()).isIncluded(join.getTargetName())) continue;
                return;
            }
        }
        if (this.delegate.dbRelationshipLoaded(entity, relationship)) {
            entity.addRelationship((Relationship)relationship);
        }
    }

    private boolean isToMany(boolean toDependentPK, DbEntity fkEntity, DbRelationship forwardRelationship) {
        return !toDependentPK || fkEntity.getPrimaryKeys().size() != forwardRelationship.getJoins().size();
    }

    private boolean isToDependentPK(DbRelationship forwardRelationship) {
        for (DbJoin dbJoin : forwardRelationship.getJoins()) {
            if (dbJoin.getTarget().isPrimaryKey()) continue;
            return false;
        }
        return true;
    }

    private void createAndAppendJoins(Set<ExportedKey> exportedKeys, DbEntity pkEntity, DbEntity fkEntity, DbRelationship forwardRelationship, DbRelationship reverseRelationship) {
        for (ExportedKey exportedKey : exportedKeys) {
            String pkName = exportedKey.getPk().getColumn();
            String fkName = exportedKey.getFk().getColumn();
            DbAttribute pkAtt = pkEntity.getAttribute(pkName);
            if (pkAtt == null) {
                LOGGER.info("no attribute for declared primary key: " + pkName);
                continue;
            }
            DbAttribute fkAtt = fkEntity.getAttribute(fkName);
            if (fkAtt == null) {
                LOGGER.info("no attribute for declared foreign key: " + fkName);
                continue;
            }
            this.addJoin(forwardRelationship, pkName, fkName);
            this.addJoin(reverseRelationship, fkName, pkName);
        }
    }

    private void addJoin(DbRelationship relationship, String sourceName, String targetName) {
        for (DbJoin join : relationship.getJoins()) {
            if (!join.getSourceName().equals(sourceName) || !join.getTargetName().equals(targetName)) continue;
            return;
        }
        relationship.addJoin(new DbJoin(relationship, sourceName, targetName));
    }
}

