/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.analysis.interpolation;

import org.apache.commons.math4.core.jdkmath.JdkMath;
import org.apache.commons.math4.legacy.analysis.interpolation.InterpolatingMicrosphere;

public class InterpolatingMicrosphere2D
extends InterpolatingMicrosphere {
    private static final int DIMENSION = 2;

    public InterpolatingMicrosphere2D(int size, double maxDarkFraction, double darkThreshold, double background) {
        super(2, size, maxDarkFraction, darkThreshold, background);
        double twopi = Math.PI * 2;
        for (int i = 0; i < size; ++i) {
            double angle = (double)i * (Math.PI * 2) / (double)size;
            this.add(new double[]{JdkMath.cos((double)angle), JdkMath.sin((double)angle)}, false);
        }
    }

    protected InterpolatingMicrosphere2D(InterpolatingMicrosphere2D other) {
        super(other);
    }

    @Override
    public InterpolatingMicrosphere2D copy() {
        return new InterpolatingMicrosphere2D(this);
    }
}

