/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.linear;

import org.apache.commons.math4.legacy.exception.DimensionMismatchException;
import org.apache.commons.math4.legacy.exception.MaxCountExceededException;
import org.apache.commons.math4.legacy.exception.NullArgumentException;
import org.apache.commons.math4.legacy.linear.ArrayRealVector;
import org.apache.commons.math4.legacy.linear.IterationManager;
import org.apache.commons.math4.legacy.linear.NonSquareOperatorException;
import org.apache.commons.math4.legacy.linear.RealLinearOperator;
import org.apache.commons.math4.legacy.linear.RealVector;

public abstract class IterativeLinearSolver {
    private final IterationManager manager;

    public IterativeLinearSolver(int maxIterations) {
        this.manager = new IterationManager(maxIterations);
    }

    public IterativeLinearSolver(IterationManager manager) throws NullArgumentException {
        NullArgumentException.check((Object)manager);
        this.manager = manager;
    }

    protected static void checkParameters(RealLinearOperator a, RealVector b, RealVector x0) throws NullArgumentException, NonSquareOperatorException, DimensionMismatchException {
        NullArgumentException.check((Object)a);
        NullArgumentException.check((Object)b);
        NullArgumentException.check((Object)x0);
        if (a.getRowDimension() != a.getColumnDimension()) {
            throw new NonSquareOperatorException(a.getRowDimension(), a.getColumnDimension());
        }
        if (b.getDimension() != a.getRowDimension()) {
            throw new DimensionMismatchException(b.getDimension(), a.getRowDimension());
        }
        if (x0.getDimension() != a.getColumnDimension()) {
            throw new DimensionMismatchException(x0.getDimension(), a.getColumnDimension());
        }
    }

    public IterationManager getIterationManager() {
        return this.manager;
    }

    public RealVector solve(RealLinearOperator a, RealVector b) throws NullArgumentException, NonSquareOperatorException, DimensionMismatchException, MaxCountExceededException {
        NullArgumentException.check((Object)a);
        ArrayRealVector x = new ArrayRealVector(a.getColumnDimension());
        ((RealVector)x).set(0.0);
        return this.solveInPlace(a, b, x);
    }

    public RealVector solve(RealLinearOperator a, RealVector b, RealVector x0) throws NullArgumentException, NonSquareOperatorException, DimensionMismatchException, MaxCountExceededException {
        NullArgumentException.check((Object)x0);
        return this.solveInPlace(a, b, x0.copy());
    }

    public abstract RealVector solveInPlace(RealLinearOperator var1, RealVector var2, RealVector var3) throws NullArgumentException, NonSquareOperatorException, DimensionMismatchException, MaxCountExceededException;
}

