/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.optim.linear;

import org.apache.commons.math4.legacy.linear.ArrayRealVector;
import org.apache.commons.math4.legacy.linear.RealVector;
import org.apache.commons.math4.legacy.optim.linear.Relationship;

public class LinearConstraint {
    private final RealVector coefficients;
    private final Relationship relationship;
    private final double value;

    public LinearConstraint(double[] coefficients, Relationship relationship, double value) {
        this(new ArrayRealVector(coefficients), relationship, value);
    }

    public LinearConstraint(RealVector coefficients, Relationship relationship, double value) {
        this.coefficients = coefficients;
        this.relationship = relationship;
        this.value = value;
    }

    public LinearConstraint(double[] lhsCoefficients, double lhsConstant, Relationship relationship, double[] rhsCoefficients, double rhsConstant) {
        double[] sub = new double[lhsCoefficients.length];
        for (int i = 0; i < sub.length; ++i) {
            sub[i] = lhsCoefficients[i] - rhsCoefficients[i];
        }
        this.coefficients = new ArrayRealVector(sub, false);
        this.relationship = relationship;
        this.value = rhsConstant - lhsConstant;
    }

    public LinearConstraint(RealVector lhsCoefficients, double lhsConstant, Relationship relationship, RealVector rhsCoefficients, double rhsConstant) {
        this.coefficients = lhsCoefficients.subtract(rhsCoefficients);
        this.relationship = relationship;
        this.value = rhsConstant - lhsConstant;
    }

    public RealVector getCoefficients() {
        return this.coefficients;
    }

    public Relationship getRelationship() {
        return this.relationship;
    }

    public double getValue() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof LinearConstraint) {
            LinearConstraint rhs = (LinearConstraint)other;
            return this.relationship == rhs.relationship && this.value == rhs.value && this.coefficients.equals(rhs.coefficients);
        }
        return false;
    }

    public int hashCode() {
        return this.relationship.hashCode() ^ Double.valueOf(this.value).hashCode() ^ this.coefficients.hashCode();
    }
}

