/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.optim.nonlinear.scalar;

import org.apache.commons.math4.core.jdkmath.JdkMath;
import org.apache.commons.math4.legacy.analysis.MultivariateFunction;
import org.apache.commons.math4.legacy.exception.DimensionMismatchException;
import org.apache.commons.math4.legacy.exception.NullArgumentException;
import org.apache.commons.math4.legacy.exception.NumberIsTooSmallException;

public class MultivariateFunctionPenaltyAdapter
implements MultivariateFunction {
    private final MultivariateFunction bounded;
    private final double[] lower;
    private final double[] upper;
    private final double offset;
    private final double[] scale;

    public MultivariateFunctionPenaltyAdapter(MultivariateFunction bounded, double[] lower, double[] upper, double offset, double[] scale) {
        NullArgumentException.check((Object)lower);
        NullArgumentException.check((Object)upper);
        NullArgumentException.check((Object)scale);
        if (lower.length != upper.length) {
            throw new DimensionMismatchException(lower.length, upper.length);
        }
        if (lower.length != scale.length) {
            throw new DimensionMismatchException(lower.length, scale.length);
        }
        for (int i = 0; i < lower.length; ++i) {
            if (upper[i] >= lower[i]) continue;
            throw new NumberIsTooSmallException((Number)upper[i], (Number)lower[i], true);
        }
        this.bounded = bounded;
        this.lower = (double[])lower.clone();
        this.upper = (double[])upper.clone();
        this.offset = offset;
        this.scale = (double[])scale.clone();
    }

    @Override
    public double value(double[] point) {
        for (int i = 0; i < this.scale.length; ++i) {
            if (!(point[i] < this.lower[i]) && !(point[i] > this.upper[i])) continue;
            double sum = 0.0;
            for (int j = i; j < this.scale.length; ++j) {
                double overshoot = point[j] < this.lower[j] ? this.scale[j] * (this.lower[j] - point[j]) : (point[j] > this.upper[j] ? this.scale[j] * (point[j] - this.upper[j]) : 0.0);
                sum += JdkMath.sqrt((double)overshoot);
            }
            return this.offset + sum;
        }
        return this.bounded.value(point);
    }
}

