/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.neuralnet.twod;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.math4.neuralnet.DistanceMeasure;
import org.apache.commons.math4.neuralnet.EuclideanDistance;
import org.apache.commons.math4.neuralnet.FeatureInitializer;
import org.apache.commons.math4.neuralnet.MapRanking;
import org.apache.commons.math4.neuralnet.Network;
import org.apache.commons.math4.neuralnet.Neuron;
import org.apache.commons.math4.neuralnet.SquareNeighbourhood;
import org.apache.commons.math4.neuralnet.internal.NeuralNetException;
import org.apache.commons.math4.neuralnet.twod.util.LocationFinder;

public class NeuronSquareMesh2D
implements Iterable<Neuron> {
    private static final int MIN_ROWS = 2;
    private final Network network;
    private final int numberOfRows;
    private final int numberOfColumns;
    private final boolean wrapRows;
    private final boolean wrapColumns;
    private final SquareNeighbourhood neighbourhood;
    private final long[][] identifiers;

    public NeuronSquareMesh2D(boolean wrapRowDim, boolean wrapColDim, SquareNeighbourhood neighbourhoodType, double[][][] featuresList) {
        this.numberOfRows = featuresList.length;
        this.numberOfColumns = featuresList[0].length;
        if (this.numberOfRows < 2) {
            throw new NeuralNetException("Number {0} is smaller than {1}", this.numberOfRows, 2);
        }
        if (this.numberOfColumns < 2) {
            throw new NeuralNetException("Number {0} is smaller than {1}", this.numberOfColumns, 2);
        }
        this.wrapRows = wrapRowDim;
        this.wrapColumns = wrapColDim;
        this.neighbourhood = neighbourhoodType;
        int fLen = featuresList[0][0].length;
        this.network = new Network(0L, fLen);
        this.identifiers = new long[this.numberOfRows][this.numberOfColumns];
        for (int i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                this.identifiers[i][j] = this.network.createNeuron(featuresList[i][j]);
            }
        }
        this.createLinks();
    }

    public NeuronSquareMesh2D(int numRows, boolean wrapRowDim, int numCols, boolean wrapColDim, SquareNeighbourhood neighbourhoodType, FeatureInitializer[] featureInit) {
        if (numRows < 2) {
            throw new NeuralNetException("Number {0} is smaller than {1}", numRows, 2);
        }
        if (numCols < 2) {
            throw new NeuralNetException("Number {0} is smaller than {1}", numCols, 2);
        }
        this.numberOfRows = numRows;
        this.wrapRows = wrapRowDim;
        this.numberOfColumns = numCols;
        this.wrapColumns = wrapColDim;
        this.neighbourhood = neighbourhoodType;
        this.identifiers = new long[this.numberOfRows][this.numberOfColumns];
        int fLen = featureInit.length;
        this.network = new Network(0L, fLen);
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numCols; ++j) {
                double[] features = new double[fLen];
                for (int fIndex = 0; fIndex < fLen; ++fIndex) {
                    features[fIndex] = featureInit[fIndex].value();
                }
                this.identifiers[i][j] = this.network.createNeuron(features);
            }
        }
        this.createLinks();
    }

    private NeuronSquareMesh2D(boolean wrapRowDim, boolean wrapColDim, SquareNeighbourhood neighbourhoodType, Network net, long[][] idGrid) {
        this.numberOfRows = idGrid.length;
        this.numberOfColumns = idGrid[0].length;
        this.wrapRows = wrapRowDim;
        this.wrapColumns = wrapColDim;
        this.neighbourhood = neighbourhoodType;
        this.network = net;
        this.identifiers = idGrid;
    }

    public synchronized NeuronSquareMesh2D copy() {
        long[][] idGrid = new long[this.numberOfRows][this.numberOfColumns];
        for (int r = 0; r < this.numberOfRows; ++r) {
            System.arraycopy(this.identifiers[r], 0, idGrid[r], 0, this.numberOfColumns);
        }
        return new NeuronSquareMesh2D(this.wrapRows, this.wrapColumns, this.neighbourhood, this.network.copy(), idGrid);
    }

    @Override
    public Iterator<Neuron> iterator() {
        return this.network.iterator();
    }

    public Network getNetwork() {
        return this.network;
    }

    public int getNumberOfRows() {
        return this.numberOfRows;
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public boolean isWrappedRow() {
        return this.wrapRows;
    }

    public boolean isWrappedColumn() {
        return this.wrapColumns;
    }

    public SquareNeighbourhood getSquareNeighbourhood() {
        return this.neighbourhood;
    }

    public Neuron getNeuron(int i, int j) {
        if (i < 0 || i >= this.numberOfRows) {
            throw new NeuralNetException("Number {0} is out of range [{1}, {2}]", i, 0, this.numberOfRows - 1);
        }
        if (j < 0 || j >= this.numberOfColumns) {
            throw new NeuralNetException("Number {0} is out of range [{1}, {2}]", i, 0, this.numberOfColumns - 1);
        }
        return this.network.getNeuron(this.identifiers[i][j]);
    }

    public Neuron getNeuron(int row, int col, HorizontalDirection alongRowDir, VerticalDirection alongColDir) {
        int[] location = this.getLocation(row, col, alongRowDir, alongColDir);
        return location == null ? null : this.getNeuron(location[0], location[1]);
    }

    public DataVisualization computeQualityIndicators(Iterable<double[]> data) {
        return DataVisualization.from(this.copy(), data);
    }

    private int[] getLocation(int row, int col, HorizontalDirection alongRowDir, VerticalDirection alongColDir) {
        int rowOffset;
        int colOffset;
        switch (alongRowDir) {
            case LEFT: {
                colOffset = -1;
                break;
            }
            case RIGHT: {
                colOffset = 1;
                break;
            }
            case CENTER: {
                colOffset = 0;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        int colIndex = col + colOffset;
        if (this.wrapColumns) {
            colIndex = colIndex < 0 ? (colIndex += this.numberOfColumns) : (colIndex %= this.numberOfColumns);
        }
        switch (alongColDir) {
            case UP: {
                rowOffset = -1;
                break;
            }
            case DOWN: {
                rowOffset = 1;
                break;
            }
            case CENTER: {
                rowOffset = 0;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        int rowIndex = row + rowOffset;
        if (this.wrapRows) {
            rowIndex = rowIndex < 0 ? (rowIndex += this.numberOfRows) : (rowIndex %= this.numberOfRows);
        }
        if (rowIndex < 0 || rowIndex >= this.numberOfRows || colIndex < 0 || colIndex >= this.numberOfColumns) {
            return null;
        }
        return new int[]{rowIndex, colIndex};
    }

    /*
     * Unable to fully structure code
     */
    private void createLinks() {
        linkEnd = new ArrayList<Long>();
        iLast = this.numberOfRows - 1;
        jLast = this.numberOfColumns - 1;
        for (i = 0; i < this.numberOfRows; ++i) {
            for (j = 0; j < this.numberOfColumns; ++j) {
                linkEnd.clear();
                switch (1.$SwitchMap$org$apache$commons$math4$neuralnet$SquareNeighbourhood[this.neighbourhood.ordinal()]) {
                    case 1: {
                        if (i > 0) {
                            if (j > 0) {
                                linkEnd.add(this.identifiers[i - 1][j - 1]);
                            }
                            if (j < jLast) {
                                linkEnd.add(this.identifiers[i - 1][j + 1]);
                            }
                        }
                        if (i < iLast) {
                            if (j > 0) {
                                linkEnd.add(this.identifiers[i + 1][j - 1]);
                            }
                            if (j < jLast) {
                                linkEnd.add(this.identifiers[i + 1][j + 1]);
                            }
                        }
                        if (this.wrapRows) {
                            if (i == 0) {
                                if (j > 0) {
                                    linkEnd.add(this.identifiers[iLast][j - 1]);
                                }
                                if (j < jLast) {
                                    linkEnd.add(this.identifiers[iLast][j + 1]);
                                }
                            } else if (i == iLast) {
                                if (j > 0) {
                                    linkEnd.add(this.identifiers[0][j - 1]);
                                }
                                if (j < jLast) {
                                    linkEnd.add(this.identifiers[0][j + 1]);
                                }
                            }
                        }
                        if (this.wrapColumns) {
                            if (j == 0) {
                                if (i > 0) {
                                    linkEnd.add(this.identifiers[i - 1][jLast]);
                                }
                                if (i < iLast) {
                                    linkEnd.add(this.identifiers[i + 1][jLast]);
                                }
                            } else if (j == jLast) {
                                if (i > 0) {
                                    linkEnd.add(this.identifiers[i - 1][0]);
                                }
                                if (i < iLast) {
                                    linkEnd.add(this.identifiers[i + 1][0]);
                                }
                            }
                        }
                        if (!this.wrapRows || !this.wrapColumns) ** GOTO lbl71
                        if (i != 0 || j != 0) ** GOTO lbl60
                        linkEnd.add(this.identifiers[iLast][jLast]);
                        ** GOTO lbl71
lbl60:
                        // 1 sources

                        if (i != 0 || j != jLast) ** GOTO lbl64
                        linkEnd.add(this.identifiers[iLast][0]);
                        ** GOTO lbl71
lbl64:
                        // 1 sources

                        if (i != iLast || j != 0) ** GOTO lbl68
                        linkEnd.add(this.identifiers[0][jLast]);
                        ** GOTO lbl71
lbl68:
                        // 1 sources

                        if (i == iLast && j == jLast) {
                            linkEnd.add(this.identifiers[0][0]);
                        }
                    }
lbl71:
                    // 8 sources

                    case 2: {
                        if (i > 0) {
                            linkEnd.add(this.identifiers[i - 1][j]);
                        }
                        if (i < iLast) {
                            linkEnd.add(this.identifiers[i + 1][j]);
                        }
                        if (this.wrapRows) {
                            if (i == 0) {
                                linkEnd.add(this.identifiers[iLast][j]);
                            } else if (i == iLast) {
                                linkEnd.add(this.identifiers[0][j]);
                            }
                        }
                        if (j > 0) {
                            linkEnd.add(this.identifiers[i][j - 1]);
                        }
                        if (j < jLast) {
                            linkEnd.add(this.identifiers[i][j + 1]);
                        }
                        if (!this.wrapColumns) break;
                        if (j == 0) {
                            linkEnd.add(this.identifiers[i][jLast]);
                            break;
                        }
                        if (j != jLast) break;
                        linkEnd.add(this.identifiers[i][0]);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                aNeuron = this.network.getNeuron(this.identifiers[i][j]);
                var7_7 = linkEnd.iterator();
                while (var7_7.hasNext()) {
                    b = (Long)var7_7.next();
                    bNeuron = this.network.getNeuron(b);
                    this.network.addLink(aNeuron, bNeuron);
                }
            }
        }
    }

    public static final class DataVisualization {
        private static final DistanceMeasure DISTANCE = new EuclideanDistance();
        private final int numberOfSamples;
        private final double[][] hitHistogram;
        private final double[][] quantizationError;
        private final double meanQuantizationError;
        private final double[][] topographicError;
        private final double meanTopographicError;
        private final double[][] uMatrix;

        private DataVisualization(int numberOfSamples, double[][] hitHistogram, double[][] quantizationError, double[][] topographicError, double[][] uMatrix) {
            this.numberOfSamples = numberOfSamples;
            this.hitHistogram = hitHistogram;
            this.quantizationError = quantizationError;
            this.meanQuantizationError = DataVisualization.hitWeightedMean(quantizationError, hitHistogram);
            this.topographicError = topographicError;
            this.meanTopographicError = DataVisualization.hitWeightedMean(topographicError, hitHistogram);
            this.uMatrix = uMatrix;
        }

        static DataVisualization from(NeuronSquareMesh2D map, Iterable<double[]> data) {
            LocationFinder finder = new LocationFinder(map);
            MapRanking rank = new MapRanking(map, DISTANCE);
            Network net = map.getNetwork();
            int nR = map.getNumberOfRows();
            int nC = map.getNumberOfColumns();
            int[][] hitCounter = new int[nR][nC];
            double[][] hitHistogram = new double[nR][nC];
            double[][] quantizationError = new double[nR][nC];
            double[][] topographicError = new double[nR][nC];
            double[][] uMatrix = new double[nR][nC];
            int numSamples = 0;
            for (double[] sample : data) {
                ++numSamples;
                List<Neuron> winners = rank.rank(sample, 2);
                Neuron best = winners.get(0);
                Neuron secondBest = winners.get(1);
                LocationFinder.Location locBest = finder.getLocation(best);
                int rowBest = locBest.getRow();
                int colBest = locBest.getColumn();
                int[] nArray = hitCounter[rowBest];
                int n = colBest;
                nArray[n] = nArray[n] + 1;
                double[] dArray = quantizationError[rowBest];
                int n2 = colBest;
                dArray[n2] = dArray[n2] + DISTANCE.applyAsDouble(sample, best.getFeatures());
                if (net.getNeighbours(best).contains(secondBest)) continue;
                double[] dArray2 = topographicError[rowBest];
                int n3 = colBest;
                dArray2[n3] = dArray2[n3] + 1.0;
            }
            for (int r = 0; r < nR; ++r) {
                for (int c = 0; c < nC; ++c) {
                    Neuron neuron = map.getNeuron(r, c);
                    Collection<Neuron> neighbours = net.getNeighbours(neuron);
                    double[] features = neuron.getFeatures();
                    double uDistance = 0.0;
                    int neighbourCount = 0;
                    for (Neuron n : neighbours) {
                        ++neighbourCount;
                        uDistance += DISTANCE.applyAsDouble(features, n.getFeatures());
                    }
                    int hitCount = hitCounter[r][c];
                    if (hitCount != 0) {
                        hitHistogram[r][c] = (double)hitCount / (double)numSamples;
                        double[] dArray = quantizationError[r];
                        int n = c;
                        dArray[n] = dArray[n] / (double)hitCount;
                        double[] dArray3 = topographicError[r];
                        int n4 = c;
                        dArray3[n4] = dArray3[n4] / (double)hitCount;
                    }
                    uMatrix[r][c] = uDistance / (double)neighbourCount;
                }
            }
            return new DataVisualization(numSamples, hitHistogram, quantizationError, topographicError, uMatrix);
        }

        public int getNumberOfSamples() {
            return this.numberOfSamples;
        }

        public double[][] getQuantizationError() {
            return DataVisualization.copy(this.quantizationError);
        }

        public double[][] getTopographicError() {
            return DataVisualization.copy(this.topographicError);
        }

        public double[][] getNormalizedHits() {
            return DataVisualization.copy(this.hitHistogram);
        }

        public double[][] getUMatrix() {
            return DataVisualization.copy(this.uMatrix);
        }

        public double getMeanQuantizationError() {
            return this.meanQuantizationError;
        }

        public double getMeanTopographicError() {
            return this.meanTopographicError;
        }

        private static double[][] copy(double[][] orig) {
            double[][] copy = new double[orig.length][];
            for (int i = 0; i < orig.length; ++i) {
                copy[i] = (double[])orig[i].clone();
            }
            return copy;
        }

        private static double hitWeightedMean(double[][] metrics, double[][] normalizedHits) {
            double mean = 0.0;
            int rows = metrics.length;
            int cols = metrics[0].length;
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    mean += normalizedHits[i][j] * metrics[i][j];
                }
            }
            return mean;
        }
    }

    public static enum VerticalDirection {
        UP,
        CENTER,
        DOWN;

    }

    public static enum HorizontalDirection {
        RIGHT,
        CENTER,
        LEFT;

    }
}

