/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.logic;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.net.InetAddresses;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.net.IPRange;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import org.opensaml.messaging.context.BaseContext;

public class IPRangePredicate
implements Predicate<BaseContext> {
    @Nullable
    private HttpServletRequest httpRequest;
    @Nonnull
    @NonnullElements
    private Collection<IPRange> addressRanges = Collections.emptyList();

    IPRangePredicate() {
    }

    @Deprecated
    public void setAddressRanges(@Nonnull @NonnullElements Iterable<IPRange> ranges) {
        DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.METHOD, (String)(this.getClass().getName() + ".setAddressRanges(Iterable)"), null, (String)"setRanges(Collection)");
        Constraint.isNotNull(ranges, (String)"Address range collection cannot be null");
        this.addressRanges = new ArrayList<IPRange>();
        for (IPRange range : Iterables.filter(ranges, (Predicate)Predicates.notNull())) {
            this.addressRanges.add(range);
        }
    }

    public void setRanges(@Nonnull @NonnullElements Collection<IPRange> ranges) {
        Constraint.isNotNull(ranges, (String)"Address range collection cannot be null");
        this.addressRanges = new ArrayList<IPRange>(Collections2.filter(ranges, (Predicate)Predicates.notNull()));
    }

    public void setHttpServletRequest(@Nonnull HttpServletRequest request) {
        this.httpRequest = (HttpServletRequest)Constraint.isNotNull((Object)request, (String)"HttpServletRequest cannot be null");
    }

    public boolean apply(@Nullable BaseContext input) {
        String address;
        String string = address = this.httpRequest != null ? this.httpRequest.getRemoteAddr() : null;
        if (address == null || !InetAddresses.isInetAddress((String)address)) {
            return false;
        }
        for (IPRange range : this.addressRanges) {
            if (!range.contains(InetAddresses.forString((String)address))) continue;
            return true;
        }
        return false;
    }
}

