/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.spring.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.fediz.spring.FederationConfig;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class FederationLogoutFilter
extends LogoutFilter {
    private FederationConfig federationConfig;
    private String logoutUrl;

    public FederationLogoutFilter(LogoutSuccessHandler logoutSuccessHandler, LogoutHandler ... handlers) {
        super(logoutSuccessHandler, handlers);
    }

    @Required
    public void setFederationConfig(FederationConfig federationConfig) {
        this.federationConfig = federationConfig;
    }

    protected boolean requiresLogout(HttpServletRequest request, HttpServletResponse response) {
        String wa = request.getParameter("wa");
        if ("wsignout1.0".equals(wa) || "wsignoutcleanup1.0".equals(wa)) {
            return true;
        }
        if (this.logoutUrl == null) {
            String contextName = request.getContextPath();
            if (contextName == null || contextName.isEmpty()) {
                contextName = "/";
            }
            this.logoutUrl = this.federationConfig.getFedizContext(contextName).getLogoutURL();
        }
        if (this.logoutUrl != null && !this.logoutUrl.isEmpty()) {
            super.setLogoutRequestMatcher((RequestMatcher)new AntPathRequestMatcher(this.logoutUrl));
            return super.requiresLogout(request, response);
        }
        return false;
    }

    protected String getFilterProcessesUrl() {
        return this.logoutUrl;
    }
}

