/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.wizards;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.ConnectionFolder;
import org.apache.directory.studio.connection.core.ConnectionFolderManager;
import org.apache.directory.studio.connection.core.ConnectionManager;
import org.apache.directory.studio.connection.core.ConnectionParameter;
import org.apache.directory.studio.connection.core.io.ConnectionIO;
import org.apache.directory.studio.connection.core.io.ConnectionIOException;
import org.apache.directory.studio.ldapbrowser.core.BrowserConnectionIO;
import org.apache.directory.studio.ldapbrowser.core.model.impl.BrowserConnection;
import org.apache.directory.studio.ldapbrowser.ui.wizards.ExportBaseWizard;
import org.apache.directory.studio.ldapbrowser.ui.wizards.ImportConnectionsWizardPage;
import org.apache.directory.studio.ldapbrowser.ui.wizards.Messages;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;

public class ImportConnectionsWizard
extends ExportBaseWizard {
    private ImportConnectionsWizardPage page;

    public ImportConnectionsWizard() {
        super(Messages.getString("ImportConnectionsWizard.ConnectionsImport"));
    }

    public static String getId() {
        return "org.apache.directory.studio.ldapbrowser.ui.wizards.ExportConnectionsWizard";
    }

    public void addPages() {
        this.page = new ImportConnectionsWizardPage();
        this.addPage((IWizardPage)this.page);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
    }

    public boolean performFinish() {
        this.page.saveDialogSettings();
        String importFileName = this.page.getImportFileName();
        try {
            ZipEntry browserConnectionsEntry;
            ZipFile importFile = new ZipFile(new File(importFileName));
            ZipEntry connectionsEntry = importFile.getEntry("connections.xml");
            if (connectionsEntry != null) {
                InputStream connectionsInputStream = importFile.getInputStream(connectionsEntry);
                ConnectionManager connectionManager = ConnectionCorePlugin.getDefault().getConnectionManager();
                Set connectionParametersSet = ConnectionIO.load((InputStream)connectionsInputStream);
                for (ConnectionParameter connectionParameter : connectionParametersSet) {
                    connectionManager.addConnection(new Connection(connectionParameter));
                }
            }
            ZipEntry connectionFoldersEntry = importFile.getEntry("connectionFolders.xml");
            ConnectionFolder rootConnectionFolder = null;
            if (connectionFoldersEntry != null) {
                InputStream connectionFoldersInputStream = importFile.getInputStream(connectionFoldersEntry);
                ConnectionFolderManager connectionFolderManager = ConnectionCorePlugin.getDefault().getConnectionFolderManager();
                Set connectionFoldersSet = ConnectionIO.loadConnectionFolders((InputStream)connectionFoldersInputStream);
                for (ConnectionFolder connectionFolder : connectionFoldersSet) {
                    if (!"0".equals(connectionFolder.getId())) {
                        connectionFolderManager.addConnectionFolder(connectionFolder);
                        continue;
                    }
                    rootConnectionFolder = connectionFolder;
                }
                if (rootConnectionFolder != null) {
                    ConnectionFolder realRootConnectionFolder = connectionFolderManager.getRootConnectionFolder();
                    List realSubFolderIds = realRootConnectionFolder.getSubFolderIds();
                    for (String subFolderId : rootConnectionFolder.getSubFolderIds()) {
                        if (realSubFolderIds.contains(subFolderId)) continue;
                        realRootConnectionFolder.addSubFolderId(subFolderId);
                    }
                    List realConnectionIds = realRootConnectionFolder.getConnectionIds();
                    for (String connectionId : rootConnectionFolder.getConnectionIds()) {
                        if (realConnectionIds.contains(connectionId)) continue;
                        realRootConnectionFolder.addConnectionId(connectionId);
                    }
                }
            }
            if ((browserConnectionsEntry = importFile.getEntry("browserconnections.xml")) != null) {
                InputStream browserConnectionsInputStream = importFile.getInputStream(browserConnectionsEntry);
                Connection[] connections = ConnectionCorePlugin.getDefault().getConnectionManager().getConnections();
                HashMap<String, BrowserConnection> connectionsMap = new HashMap<String, BrowserConnection>();
                int i = 0;
                while (i < connections.length) {
                    Connection connection = connections[i];
                    BrowserConnection browserConnection = new BrowserConnection(connection);
                    connectionsMap.put(connection.getId(), browserConnection);
                    ++i;
                }
                BrowserConnectionIO.load((InputStream)browserConnectionsInputStream, connectionsMap);
            }
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ConnectionIOException e) {
            e.printStackTrace();
        }
        return true;
    }
}

