/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.config.convert;

import inet.ipaddr.IPAddress;
import java.lang.reflect.Field;
import java.net.URI;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.eventmesh.common.config.ConfigFiled;
import org.apache.eventmesh.common.config.convert.ConvertValue;
import org.apache.eventmesh.common.config.convert.converter.BaseDataTypeConverter;
import org.apache.eventmesh.common.config.convert.converter.DateConverter;
import org.apache.eventmesh.common.config.convert.converter.EnumConverter;
import org.apache.eventmesh.common.config.convert.converter.IPAddressConverter;
import org.apache.eventmesh.common.config.convert.converter.ListConverter;
import org.apache.eventmesh.common.config.convert.converter.LocalDateConverter;
import org.apache.eventmesh.common.config.convert.converter.LocalDateTimeConverter;
import org.apache.eventmesh.common.config.convert.converter.MapConverter;
import org.apache.eventmesh.common.config.convert.converter.ObjectConverter;
import org.apache.eventmesh.common.config.convert.converter.PropertiesConverter;
import org.apache.eventmesh.common.config.convert.converter.StringConverter;
import org.apache.eventmesh.common.config.convert.converter.URIConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConverterMap {
    private static final Logger log = LoggerFactory.getLogger(ConverterMap.class);
    private static final ObjectConverter objectConverter = new ObjectConverter();
    private static final Map<Class<?>, ConvertValue<?>> classToConverter = new HashMap();

    public static void register(ConvertValue<?> convertValue, Class<?> ... clazzs) {
        for (Class<?> clazz : clazzs) {
            classToConverter.put(clazz, convertValue);
        }
    }

    public static ConvertValue<?> getFieldConverter(Field field) {
        Class<?> clazz = field.getType();
        ConfigFiled configFiled = field.getAnnotation(ConfigFiled.class);
        Class<?> converter1 = configFiled.converter();
        if (!converter1.equals(ConvertValue.DefaultConverter.class)) {
            if (!classToConverter.containsKey(converter1)) {
                try {
                    ConvertValue convertValue = (ConvertValue)converter1.newInstance();
                    ConverterMap.register(convertValue, converter1);
                }
                catch (Exception e) {
                    log.error("The converter failed to register.", (Throwable)e);
                }
            }
            return classToConverter.get(converter1);
        }
        return ConverterMap.getClazzConverter(clazz);
    }

    public static ConvertValue<?> getClazzConverter(Class<?> clazz) {
        ConvertValue<Object> converter = classToConverter.get(clazz);
        if (Objects.isNull(converter)) {
            converter = clazz.isEnum() ? classToConverter.get(Enum.class) : objectConverter;
        }
        return converter;
    }

    public static Map<Class<?>, ConvertValue<?>> getClassToConverter() {
        return classToConverter;
    }

    public static ObjectConverter getObjectConverter() {
        return objectConverter;
    }

    static {
        ConverterMap.register(new URIConverter(), URI.class);
        ConverterMap.register(new EnumConverter(), Enum.class);
        ConverterMap.register(new DateConverter(), Date.class);
        ConverterMap.register(new StringConverter(), String.class);
        ConverterMap.register(new LocalDateConverter(), LocalDate.class);
        ConverterMap.register(new IPAddressConverter(), IPAddress.class);
        ConverterMap.register(new PropertiesConverter(), Properties.class);
        ConverterMap.register(new LocalDateTimeConverter(), LocalDateTime.class);
        ConverterMap.register(new ListConverter(), List.class, ArrayList.class, LinkedList.class, Vector.class);
        ConverterMap.register(new MapConverter(), Map.class, HashMap.class, TreeMap.class, LinkedHashMap.class);
        ConverterMap.register(new BaseDataTypeConverter.CharacterConverter(), Character.class, Character.TYPE);
        ConverterMap.register(new BaseDataTypeConverter.ByteConverter(), Byte.class, Byte.TYPE);
        ConverterMap.register(new BaseDataTypeConverter.ShortConverter(), Short.class, Short.TYPE);
        ConverterMap.register(new BaseDataTypeConverter.IntegerConverter(), Integer.class, Integer.TYPE);
        ConverterMap.register(new BaseDataTypeConverter.LongConverter(), Long.class, Long.TYPE);
        ConverterMap.register(new BaseDataTypeConverter.FloatConverter(), Float.class, Float.TYPE);
        ConverterMap.register(new BaseDataTypeConverter.DoubleConverter(), Double.class, Double.TYPE);
        ConverterMap.register(new BaseDataTypeConverter.BooleanConverter(), Boolean.class, Boolean.TYPE);
    }
}

