/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.storage.rocketmq.admin;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.admin.AbstractAdmin;
import org.apache.eventmesh.api.admin.TopicProperties;
import org.apache.eventmesh.common.config.ConfigService;
import org.apache.eventmesh.storage.rocketmq.config.ClientConfiguration;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.admin.TopicOffset;
import org.apache.rocketmq.common.admin.TopicStatsTable;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.admin.MQAdminExt;
import org.apache.rocketmq.tools.command.CommandUtil;

public class RocketMQAdmin
extends AbstractAdmin {
    private final RPCHook rpcHook;
    protected String nameServerAddr;
    protected String clusterName;
    private int numOfQueue = 4;
    private int queuePermission = 6;

    public RocketMQAdmin() {
        super(new AtomicBoolean(false));
        ConfigService configService = ConfigService.getInstance();
        ClientConfiguration clientConfiguration = (ClientConfiguration)configService.buildConfigInstance(ClientConfiguration.class);
        this.nameServerAddr = clientConfiguration.getNamesrvAddr();
        this.clusterName = clientConfiguration.getClusterName();
        String accessKey = clientConfiguration.getAccessKey();
        String secretKey = clientConfiguration.getSecretKey();
        this.rpcHook = new AclClientRPCHook(new SessionCredentials(accessKey, secretKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TopicProperties> getTopic() throws Exception {
        DefaultMQAdminExt adminExt = this.createMQAdminExt();
        try {
            ArrayList<TopicProperties> result = new ArrayList<TopicProperties>();
            adminExt.start();
            Set topicList = adminExt.fetchAllTopicList().getTopicList();
            for (String topic : topicList) {
                long messageCount = 0L;
                TopicStatsTable topicStats = adminExt.examineTopicStats(topic);
                HashMap offsetTable = topicStats.getOffsetTable();
                for (TopicOffset topicOffset : offsetTable.values()) {
                    messageCount += topicOffset.getMaxOffset() - topicOffset.getMinOffset();
                }
                result.add(new TopicProperties(topic, messageCount));
            }
            result.sort(Comparator.comparing(t -> t.name));
            ArrayList<TopicProperties> arrayList = result;
            return arrayList;
        }
        finally {
            adminExt.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTopic(String topicName) throws Exception {
        if (StringUtils.isBlank((CharSequence)topicName)) {
            throw new Exception("Topic name can not be blank");
        }
        DefaultMQAdminExt adminExt = this.createMQAdminExt();
        try {
            adminExt.start();
            Set brokerAddress = CommandUtil.fetchMasterAddrByClusterName((MQAdminExt)adminExt, (String)this.clusterName);
            for (String masterAddress : brokerAddress) {
                TopicConfig topicConfig = new TopicConfig();
                topicConfig.setTopicName(topicName);
                topicConfig.setReadQueueNums(this.numOfQueue);
                topicConfig.setWriteQueueNums(this.numOfQueue);
                topicConfig.setPerm(this.queuePermission);
                adminExt.createAndUpdateTopicConfig(masterAddress, topicConfig);
            }
        }
        finally {
            adminExt.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTopic(String topicName) throws Exception {
        if (StringUtils.isBlank((CharSequence)topicName)) {
            throw new Exception("Topic name can not be blank.");
        }
        DefaultMQAdminExt adminExt = this.createMQAdminExt();
        try {
            adminExt.start();
            Set brokerAddress = CommandUtil.fetchMasterAddrByClusterName((MQAdminExt)adminExt, (String)this.clusterName);
            adminExt.deleteTopicInBroker(brokerAddress, topicName);
        }
        finally {
            adminExt.shutdown();
        }
    }

    private DefaultMQAdminExt createMQAdminExt() {
        DefaultMQAdminExt adminExt = new DefaultMQAdminExt(this.rpcHook);
        String groupId = UUID.randomUUID().toString();
        adminExt.setAdminExtGroup("admin_ext_group-" + groupId);
        adminExt.setNamesrvAddr(this.nameServerAddr);
        return adminExt;
    }
}

