/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.classloader;

import com.navercorp.pinpoint.bootstrap.classloader.ClassLoaderFactory;
import com.navercorp.pinpoint.bootstrap.classloader.DynamicClassLoaderFactory;
import com.navercorp.pinpoint.bootstrap.classloader.URLClassLoaderFactory;
import com.navercorp.pinpoint.common.util.JvmUtils;
import com.navercorp.pinpoint.common.util.JvmVersion;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.List;

public final class PinpointClassLoaderFactory {
    private static final ClassLoaderFactory CLASS_LOADER_FACTORY = PinpointClassLoaderFactory.createClassLoaderFactory();
    private static final String PARALLEL_CLASS_LOADER_FACTORY = "com.navercorp.pinpoint.bootstrap.classloader.ParallelClassLoaderFactory";
    private static final String JAVA9_CLASSLOADER = "com.navercorp.pinpoint.bootstrap.java9.classloader.Java9ClassLoader";

    private PinpointClassLoaderFactory() {
        throw new IllegalAccessError();
    }

    public static ClassLoaderFactory createClassLoaderFactory() {
        JvmVersion jvmVersion = JvmUtils.getVersion();
        if (jvmVersion.onOrAfter(JvmVersion.JAVA_9)) {
            return PinpointClassLoaderFactory.newClassLoaderFactory(JAVA9_CLASSLOADER);
        }
        if (PinpointClassLoaderFactory.disableChildFirst()) {
            return new URLClassLoaderFactory();
        }
        return PinpointClassLoaderFactory.newParallelClassLoaderFactory();
    }

    private static boolean disableChildFirst() {
        String disable = System.getProperty("pinpoint.agent.classloader.childfirst.disable");
        return "true".equalsIgnoreCase(disable);
    }

    private static ClassLoaderFactory newClassLoaderFactory(String factoryName) {
        ClassLoader classLoader = PinpointClassLoaderFactory.class.getClassLoader();
        return new DynamicClassLoaderFactory(factoryName, classLoader);
    }

    private static ClassLoaderFactory newParallelClassLoaderFactory() {
        try {
            ClassLoader classLoader = PinpointClassLoaderFactory.class.getClassLoader();
            Class<?> classLoaderFactoryClazz = Class.forName(PARALLEL_CLASS_LOADER_FACTORY, true, classLoader);
            Constructor<?> constructor = classLoaderFactoryClazz.getDeclaredConstructor(new Class[0]);
            return (ClassLoaderFactory)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("com.navercorp.pinpoint.bootstrap.classloader.ParallelClassLoaderFactory create fail Caused by:" + e.getMessage(), e);
        }
    }

    public static ClassLoader createClassLoader(String name, URL[] urls, ClassLoader parent, List<String> libClass) {
        return CLASS_LOADER_FACTORY.createClassLoader(name, urls, parent, libClass);
    }
}

