/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.client;

import com.navercorp.pinpoint.rpc.MessageListener;
import com.navercorp.pinpoint.rpc.PinpointSocket;
import com.navercorp.pinpoint.rpc.packet.RequestPacket;
import com.navercorp.pinpoint.rpc.packet.SendPacket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimpleMessageListener
implements MessageListener {
    private final Logger logger = LogManager.getLogger(this.getClass());
    public static final SimpleMessageListener INSTANCE = new SimpleMessageListener();
    public static final SimpleMessageListener ECHO_INSTANCE = new SimpleMessageListener(true);
    private final boolean echo;

    public SimpleMessageListener() {
        this(false);
    }

    public SimpleMessageListener(boolean echo) {
        this.echo = echo;
    }

    @Override
    public void handleSend(SendPacket sendPacket, PinpointSocket pinpointSocket) {
        this.logger.info("handleSend packet:{}, remote:{}", (Object)sendPacket, (Object)pinpointSocket.getRemoteAddress());
    }

    @Override
    public void handleRequest(RequestPacket requestPacket, PinpointSocket pinpointSocket) {
        this.logger.info("handleRequest packet:{}, remote:{}", (Object)requestPacket, (Object)pinpointSocket.getRemoteAddress());
        if (this.echo) {
            pinpointSocket.response(requestPacket.getRequestId(), requestPacket.getPayload());
        } else {
            pinpointSocket.response(requestPacket.getRequestId(), new byte[0]);
        }
    }
}

