/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol;

import io.cloudevents.CloudEvent;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.eventmesh.runtime.core.protocol.DelayRetryable;

public abstract class RetryContext
implements DelayRetryable {
    public CloudEvent event;
    public String seq;
    public int retryTimes;
    public long executeTime = System.currentTimeMillis();

    public RetryContext delay(long delay) {
        this.executeTime = System.currentTimeMillis() + (long)(this.retryTimes + 1) * delay;
        return this;
    }

    @Override
    public int compareTo(@Nonnull Delayed delayed) {
        RetryContext obj = (RetryContext)delayed;
        return Long.compare(this.executeTime, obj.executeTime);
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.executeTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }
}

