/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.producer;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.common.ServiceState;
import org.apache.eventmesh.runtime.core.consumergroup.ProducerGroupConf;
import org.apache.eventmesh.runtime.core.protocol.grpc.producer.EventMeshProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerManager {
    private static final Logger log = LoggerFactory.getLogger(ProducerManager.class);
    private EventMeshGrpcServer eventMeshGrpcServer;
    private final ConcurrentHashMap<String, EventMeshProducer> producerTable = new ConcurrentHashMap();

    public ProducerManager(EventMeshGrpcServer eventMeshGrpcServer) {
        this.eventMeshGrpcServer = eventMeshGrpcServer;
    }

    public void init() throws Exception {
        log.info("Grpc ProducerManager inited......");
    }

    public void start() throws Exception {
        log.info("Grpc ProducerManager started......");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventMeshProducer getEventMeshProducer(String producerGroup) throws Exception {
        EventMeshProducer eventMeshProducer = null;
        if (!this.producerTable.containsKey(producerGroup)) {
            ConcurrentHashMap<String, EventMeshProducer> concurrentHashMap = this.producerTable;
            synchronized (concurrentHashMap) {
                if (!this.producerTable.containsKey(producerGroup)) {
                    ProducerGroupConf producerGroupConfig = new ProducerGroupConf(producerGroup);
                    eventMeshProducer = this.createEventMeshProducer(producerGroupConfig);
                    eventMeshProducer.start();
                }
            }
        }
        if (ServiceState.RUNNING != (eventMeshProducer = this.producerTable.get(producerGroup)).getStatus()) {
            eventMeshProducer.start();
        }
        return eventMeshProducer;
    }

    private synchronized EventMeshProducer createEventMeshProducer(ProducerGroupConf producerGroupConfig) throws Exception {
        if (this.producerTable.containsKey(producerGroupConfig.getGroupName())) {
            return this.producerTable.get(producerGroupConfig.getGroupName());
        }
        EventMeshProducer eventMeshProducer = new EventMeshProducer();
        eventMeshProducer.init(this.eventMeshGrpcServer.getEventMeshGrpcConfiguration(), producerGroupConfig);
        this.producerTable.put(producerGroupConfig.getGroupName(), eventMeshProducer);
        return eventMeshProducer;
    }

    public void shutdown() {
        for (EventMeshProducer eventMeshProducer : this.producerTable.values()) {
            try {
                eventMeshProducer.shutdown();
            }
            catch (Exception ex) {
                log.error("shutdown eventMeshProducer[{}] err", (Object)eventMeshProducer, (Object)ex);
            }
        }
        log.info("producerManager shutdown......");
    }
}

