/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.consumer;

import io.cloudevents.CloudEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.eventmesh.api.AbstractContext;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupConf;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupTopicConf;
import org.apache.eventmesh.runtime.core.protocol.http.consumer.EventMeshConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandleMsgContext {
    private static final Logger log = LoggerFactory.getLogger(HandleMsgContext.class);
    private String msgRandomNo;
    private String consumerGroup;
    private EventMeshConsumer eventMeshConsumer;
    private String bizSeqNo;
    private String uniqueId;
    private String topic;
    private SubscriptionItem subscriptionItem;
    private CloudEvent event;
    private int ttl;
    private long createTime = System.currentTimeMillis();
    private AbstractContext context;
    private ConsumerGroupConf consumerGroupConfig;
    private final transient EventMeshHTTPServer eventMeshHTTPServer;
    private ConsumerGroupTopicConf consumeTopicConfig;
    private Map<String, String> props;

    public HandleMsgContext(String msgRandomNo, String consumerGroup, EventMeshConsumer eventMeshConsumer, String topic, CloudEvent event, SubscriptionItem subscriptionItem, AbstractContext context, ConsumerGroupConf consumerGroupConfig, EventMeshHTTPServer eventMeshHTTPServer, String bizSeqNo, String uniqueId, ConsumerGroupTopicConf consumeTopicConfig) {
        this.msgRandomNo = msgRandomNo;
        this.consumerGroup = consumerGroup;
        this.eventMeshConsumer = eventMeshConsumer;
        this.topic = topic;
        this.event = event;
        this.subscriptionItem = subscriptionItem;
        this.context = context;
        this.consumerGroupConfig = consumerGroupConfig;
        this.eventMeshHTTPServer = eventMeshHTTPServer;
        this.bizSeqNo = bizSeqNo;
        this.uniqueId = uniqueId;
        this.consumeTopicConfig = consumeTopicConfig;
        String ttlStr = (String)event.getExtension("timeout");
        this.ttl = StringUtils.isNumeric((CharSequence)ttlStr) ? Integer.parseInt(ttlStr) : 3000;
    }

    public void addProp(String key, String val) {
        if (this.props == null) {
            this.props = new HashMap<String, String>();
        }
        this.props.put(key, val);
    }

    public String getProp(String key) {
        return this.props.get(key);
    }

    public String getMsgRandomNo() {
        return this.msgRandomNo;
    }

    public void setMsgRandomNo(String msgRandomNo) {
        this.msgRandomNo = msgRandomNo;
    }

    public ConsumerGroupTopicConf getConsumeTopicConfig() {
        return this.consumeTopicConfig;
    }

    public void setConsumeTopicConfig(ConsumerGroupTopicConf consumeTopicConfig) {
        this.consumeTopicConfig = consumeTopicConfig;
    }

    public String getBizSeqNo() {
        return this.bizSeqNo;
    }

    public void setBizSeqNo(String bizSeqNo) {
        this.bizSeqNo = bizSeqNo;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public void setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
    }

    public EventMeshConsumer getEventMeshConsumer() {
        return this.eventMeshConsumer;
    }

    public void setEventMeshConsumer(EventMeshConsumer eventMeshConsumer) {
        this.eventMeshConsumer = eventMeshConsumer;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public CloudEvent getEvent() {
        return this.event;
    }

    public void setEvent(CloudEvent event) {
        this.event = event;
    }

    public SubscriptionItem getSubscriptionItem() {
        return this.subscriptionItem;
    }

    public void setSubscriptionItem(SubscriptionItem subscriptionItem) {
        this.subscriptionItem = subscriptionItem;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public AbstractContext getContext() {
        return this.context;
    }

    public void setContext(AbstractContext context) {
        this.context = context;
    }

    public ConsumerGroupConf getConsumerGroupConfig() {
        return this.consumerGroupConfig;
    }

    public void setConsumerGroupConfig(ConsumerGroupConf consumerGroupConfig) {
        this.consumerGroupConfig = consumerGroupConfig;
    }

    public EventMeshHTTPServer getEventMeshHTTPServer() {
        return this.eventMeshHTTPServer;
    }

    public void finish() {
        if (Objects.nonNull(this.eventMeshConsumer) && Objects.nonNull(this.context) && Objects.nonNull(this.event)) {
            if (log.isDebugEnabled()) {
                log.debug("messageAcked|topic={}|event={}", (Object)this.topic, (Object)this.event);
            }
            this.eventMeshConsumer.updateOffset(this.topic, this.subscriptionItem.getMode(), Collections.singletonList(this.event), this.context);
        }
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public int getTtl() {
        return this.ttl;
    }

    public void setTtl(int ttl) {
        this.ttl = ttl;
    }

    public String toString() {
        return "handleMsgContext={" + "consumerGroup=" + this.consumerGroup + ",topic=" + this.topic + ",subscriptionItem=" + this.subscriptionItem + ",consumeTopicConfig=" + this.consumeTopicConfig + ",bizSeqNo=" + this.bizSeqNo + ",uniqueId=" + this.uniqueId + ",ttl=" + this.ttl + ",createTime=" + DateFormatUtils.format((long)this.createTime, (String)"yyyy-MM-dd HH:mm:ss.SSS") + '}';
    }
}

