/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor;

import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventData;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.protocol.ProtocolTransportObject;
import org.apache.eventmesh.common.protocol.http.HttpCommand;
import org.apache.eventmesh.common.protocol.http.body.message.SendMessageBatchResponseBody;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.protocol.http.header.message.SendMessageBatchRequestHeader;
import org.apache.eventmesh.common.protocol.http.header.message.SendMessageBatchResponseHeader;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.metrics.api.model.HttpSummaryMetrics;
import org.apache.eventmesh.protocol.api.ProtocolAdaptor;
import org.apache.eventmesh.protocol.api.ProtocolPluginFactory;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.configuration.EventMeshHTTPConfiguration;
import org.apache.eventmesh.runtime.constants.EventMeshConstants;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.HttpRequestProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.producer.EventMeshProducer;
import org.apache.eventmesh.runtime.core.protocol.http.producer.SendMessageContext;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchSendMessageProcessor
implements HttpRequestProcessor {
    private final Logger cmdLogger = LoggerFactory.getLogger((String)"cmd");
    private final Logger aclLogger = LoggerFactory.getLogger((String)"acl");
    private final Logger batchMessageLogger = LoggerFactory.getLogger((String)"batchMessage");
    private final EventMeshHTTPServer eventMeshHTTPServer;
    private final Acl acl;

    public BatchSendMessageProcessor(EventMeshHTTPServer eventMeshHTTPServer) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
        this.acl = eventMeshHTTPServer.getAcl();
    }

    @Override
    public void processRequest(ChannelHandlerContext ctx, AsyncContext<HttpCommand> asyncContext) throws Exception {
        String localAddress = IPUtils.getLocalAddress();
        HttpCommand request = asyncContext.getRequest();
        this.cmdLogger.info("cmd={}|{}|client2eventMesh|from={}|to={}", new Object[]{RequestCode.get((Integer)Integer.valueOf(request.getRequestCode())), "http", RemotingHelper.parseChannelRemoteAddr(ctx.channel()), localAddress});
        SendMessageBatchRequestHeader sendMessageBatchRequestHeader = (SendMessageBatchRequestHeader)request.getHeader();
        EventMeshHTTPConfiguration httpConfiguration = this.eventMeshHTTPServer.getEventMeshHttpConfiguration();
        SendMessageBatchResponseHeader sendMessageBatchResponseHeader = SendMessageBatchResponseHeader.buildHeader((Integer)Integer.valueOf(request.getRequestCode()), (String)httpConfiguration.getEventMeshCluster(), (String)localAddress, (String)httpConfiguration.getEventMeshEnv(), (String)httpConfiguration.getEventMeshIDC());
        String protocolType = sendMessageBatchRequestHeader.getProtocolType();
        ProtocolAdaptor httpCommandProtocolAdaptor = ProtocolPluginFactory.getProtocolAdaptor((String)protocolType);
        List eventList = httpCommandProtocolAdaptor.toBatchCloudEvent((ProtocolTransportObject)request);
        if (CollectionUtils.isEmpty((Collection)eventList)) {
            this.completeResponse(request, asyncContext, sendMessageBatchResponseHeader, EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR, null, SendMessageBatchResponseBody.class);
            return;
        }
        String batchId = "";
        String producerGroup = "";
        int eventSize = eventList.size();
        if (eventSize > httpConfiguration.getEventMeshEventBatchSize()) {
            this.batchMessageLogger.error("Event batch size exceeds the limit: {}", (Object)httpConfiguration.getEventMeshEventBatchSize());
            this.completeResponse(request, asyncContext, sendMessageBatchResponseHeader, EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR, "Event batch size exceeds the limit: " + httpConfiguration.getEventMeshEventBatchSize(), SendMessageBatchResponseBody.class);
            return;
        }
        for (CloudEvent event : eventList) {
            String sys;
            String pid;
            String content;
            if (!ObjectUtils.allNotNull((Object[])new Object[]{event.getSource(), event.getSpecVersion()}) || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{event.getId(), event.getType(), event.getSubject()})) {
                this.completeResponse(request, asyncContext, sendMessageBatchResponseHeader, EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR, null, SendMessageBatchResponseBody.class);
                return;
            }
            String string = content = event.getData() == null ? "" : new String(event.getData().toBytes(), Constants.DEFAULT_CHARSET);
            if (content.length() > httpConfiguration.getEventMeshEventSize()) {
                this.batchMessageLogger.error("Event size exceeds the limit: {}", (Object)httpConfiguration.getEventMeshEventSize());
                this.completeResponse(request, asyncContext, sendMessageBatchResponseHeader, EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR, "Event size exceeds the limit: " + httpConfiguration.getEventMeshEventSize(), SendMessageBatchResponseBody.class);
                return;
            }
            String idc = this.getExtension(event, "idc");
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{idc, pid = this.getExtension(event, "pid"), sys = this.getExtension(event, "sys")}) || !StringUtils.isNumeric((CharSequence)pid)) {
                this.completeResponse(request, asyncContext, sendMessageBatchResponseHeader, EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR, null, SendMessageBatchResponseBody.class);
                return;
            }
            batchId = this.getExtension(event, "batchId");
            producerGroup = this.getExtension(event, "producerGroup");
            eventSize = Integer.parseInt(this.getExtension(event, "size"));
            CloudEventData eventData = event.getData();
            if (eventData != null && !StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{batchId, producerGroup}) && eventSize == eventList.size()) continue;
            this.completeResponse(request, asyncContext, sendMessageBatchResponseHeader, EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR, null, SendMessageBatchResponseBody.class);
            return;
        }
        HttpSummaryMetrics summaryMetrics = this.eventMeshHTTPServer.getMetrics().getSummaryMetrics();
        if (!this.eventMeshHTTPServer.getBatchRateLimiter().tryAcquire(eventSize, 100L, TimeUnit.MILLISECONDS)) {
            summaryMetrics.recordSendBatchMsgDiscard((long)eventSize);
            this.completeResponse(request, asyncContext, sendMessageBatchResponseHeader, EventMeshRetCode.EVENTMESH_BATCH_SPEED_OVER_LIMIT_ERR, null, SendMessageBatchResponseBody.class);
            return;
        }
        EventMeshProducer batchEventMeshProducer = this.eventMeshHTTPServer.getProducerManager().getEventMeshProducer(producerGroup);
        batchEventMeshProducer.getMqProducerWrapper().getMeshMQProducer().setExtFields();
        if (!batchEventMeshProducer.isStarted()) {
            this.completeResponse(request, asyncContext, sendMessageBatchResponseHeader, EventMeshRetCode.EVENTMESH_BATCH_PRODUCER_STOPED_ERR, null, SendMessageBatchResponseBody.class);
            return;
        }
        long batchStartTime = System.currentTimeMillis();
        String remoteAddr = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
        int requestCode = Integer.parseInt(request.getRequestCode());
        ConcurrentHashMap topicBatchMessageMappings = new ConcurrentHashMap();
        for (CloudEvent cloudEvent : eventList) {
            if (StringUtils.isBlank((CharSequence)cloudEvent.getSubject()) || cloudEvent.getData() == null) continue;
            Iterator user = this.getExtension(cloudEvent, "username");
            String pass = this.getExtension(cloudEvent, "passwd");
            String subsystem = this.getExtension(cloudEvent, "sys");
            if (httpConfiguration.isEventMeshServerSecurityEnable()) {
                try {
                    this.acl.doAclCheckInHttpSend(remoteAddr, (String)((Object)user), pass, subsystem, cloudEvent.getSubject(), requestCode);
                }
                catch (Exception e) {
                    this.completeResponse(request, asyncContext, sendMessageBatchResponseHeader, EventMeshRetCode.EVENTMESH_ACL_ERR, e.getMessage(), SendMessageBatchResponseBody.class);
                    this.aclLogger.warn("CLIENT HAS NO PERMISSION,BatchSendMessageProcessor send failed", (Throwable)e);
                    return;
                }
            }
            try {
                String ttl = this.getExtension(cloudEvent, "ttl");
                if (StringUtils.isBlank((CharSequence)ttl) || !StringUtils.isNumeric((CharSequence)ttl)) {
                    cloudEvent = CloudEventBuilder.from((CloudEvent)cloudEvent).withExtension("ttl", String.valueOf(EventMeshConstants.DEFAULT_MSG_TTL_MILLS)).withExtension("msgtype", "persistent").build();
                }
                if (topicBatchMessageMappings.containsKey(cloudEvent.getSubject())) {
                    ((List)topicBatchMessageMappings.get(cloudEvent.getSubject())).add(cloudEvent);
                } else {
                    ArrayList<CloudEvent> tmp = new ArrayList<CloudEvent>();
                    tmp.add(cloudEvent);
                    topicBatchMessageMappings.put(cloudEvent.getSubject(), tmp);
                }
                if (!this.batchMessageLogger.isDebugEnabled()) continue;
                this.batchMessageLogger.debug("msg2MQMsg suc, event:{}", (Object)cloudEvent.getData());
            }
            catch (Exception e) {
                this.batchMessageLogger.error("msg2MQMsg err, event:{}", (Object)cloudEvent.getData(), (Object)e);
            }
        }
        if (CollectionUtils.isEmpty((Collection)eventList)) {
            this.completeResponse(request, asyncContext, sendMessageBatchResponseHeader, EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR, null, SendMessageBatchResponseBody.class);
            return;
        }
        long delta = eventSize;
        summaryMetrics.recordSendBatchMsg(delta);
        if (httpConfiguration.isEventMeshServerBatchMsgBatchEnabled()) {
            for (List eventlist : topicBatchMessageMappings.values()) {
                CloudEvent event = null;
                final SendMessageContext sendMessageContext = new SendMessageContext(batchId, event, batchEventMeshProducer, this.eventMeshHTTPServer);
                sendMessageContext.setEventList(eventlist);
                batchEventMeshProducer.send(sendMessageContext, new SendCallback(){

                    public void onSuccess(SendResult sendResult) {
                    }

                    public void onException(OnExceptionContext context) {
                        BatchSendMessageProcessor.this.batchMessageLogger.warn("", (Throwable)context.getException());
                        BatchSendMessageProcessor.this.eventMeshHTTPServer.getHttpRetryer().pushRetry(sendMessageContext.delay(10000L));
                    }
                });
            }
        } else {
            for (CloudEvent event : eventList) {
                final SendMessageContext sendMessageContext = new SendMessageContext(batchId, event, batchEventMeshProducer, this.eventMeshHTTPServer);
                batchEventMeshProducer.send(sendMessageContext, new SendCallback(){

                    public void onSuccess(SendResult sendResult) {
                    }

                    public void onException(OnExceptionContext context) {
                        BatchSendMessageProcessor.this.batchMessageLogger.warn("", (Throwable)context.getException());
                        BatchSendMessageProcessor.this.eventMeshHTTPServer.getHttpRetryer().pushRetry(sendMessageContext.delay(10000L));
                    }
                });
            }
        }
        long batchEndTime = System.currentTimeMillis();
        summaryMetrics.recordBatchSendMsgCost(batchEndTime - batchStartTime);
        this.batchMessageLogger.debug("batchMessage|eventMesh2mq|REQ|ASYNC|batchId={}|send2MQCost={}ms|msgNum={}|topics={}", new Object[]{batchId, batchEndTime - batchStartTime, eventSize, topicBatchMessageMappings.keySet()});
        this.completeResponse(request, asyncContext, sendMessageBatchResponseHeader, EventMeshRetCode.SUCCESS, null, SendMessageBatchResponseBody.class);
    }
}

