/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor.inf;

import io.cloudevents.CloudEvent;
import io.netty.channel.ChannelHandlerContext;
import java.lang.reflect.Method;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.http.HttpCommand;
import org.apache.eventmesh.common.protocol.http.body.Body;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.header.Header;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface HttpRequestProcessor {
    public static final Logger log = LoggerFactory.getLogger(HttpRequestProcessor.class);

    public void processRequest(ChannelHandlerContext var1, AsyncContext<HttpCommand> var2) throws Exception;

    default public boolean rejectRequest() {
        return false;
    }

    default public <T extends Header, E extends Body> void completeResponse(HttpCommand req, AsyncContext asyncContext, T respHeader, EventMeshRetCode emCode, String msg, Class<E> clazz) {
        try {
            Method method = clazz.getMethod("buildBody", Integer.class, String.class);
            Object o = method.invoke(null, emCode.getRetCode(), StringUtils.isNotBlank((CharSequence)msg) ? msg : emCode.getErrMsg());
            HttpCommand response = req.createHttpCommandResponse(respHeader, (Body)o);
            asyncContext.onComplete(response);
        }
        catch (Exception e) {
            log.error("response failed", (Throwable)e);
        }
    }

    default public String getExtension(CloudEvent event, String protocolKey) {
        Object extension = event.getExtension(protocolKey);
        return Objects.isNull(extension) ? "" : extension.toString();
    }
}

