/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.task;

import io.netty.channel.ChannelHandlerContext;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.common.protocol.tcp.OPStatus;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.task.AbstractTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenTask
extends AbstractTask {
    private static final Logger log = LoggerFactory.getLogger(ListenTask.class);

    public ListenTask(Package pkg, ChannelHandlerContext ctx, long startTime, EventMeshTCPServer eventMeshTCPServer) {
        super(pkg, ctx, startTime, eventMeshTCPServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long taskExecuteTime = System.currentTimeMillis();
        Header header = new Header(Command.LISTEN_RESPONSE, OPStatus.SUCCESS.getCode().intValue(), OPStatus.SUCCESS.getDesc(), this.pkg.getHeader().getSeq());
        this.session.setListenRequestSeq(this.pkg.getHeader().getSeq());
        try {
            Session session = this.session;
            synchronized (session) {
                this.eventMeshTCPServer.getClientSessionGroupMapping().readySession(this.session);
            }
        }
        catch (Exception e) {
            log.error("ListenTask failed|user={}|errMsg={}", (Object)this.session.getClient(), (Object)e);
            Integer status = OPStatus.FAIL.getCode();
            header = new Header(Command.LISTEN_RESPONSE, status.intValue(), e.toString(), this.pkg.getHeader().getSeq());
        }
        finally {
            this.session.trySendListenResponse(header, this.startTime, taskExecuteTime);
        }
    }
}

