/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.common.annotations.InterfaceAudience;
import com.navercorp.pinpoint.profiler.context.BaseTraceFactory;
import com.navercorp.pinpoint.profiler.context.LocalAsyncId;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoggingBaseTraceFactory
implements BaseTraceFactory {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final BaseTraceFactory baseTraceFactory;

    public static BaseTraceFactory wrap(BaseTraceFactory baseTraceFactory) {
        Objects.requireNonNull(baseTraceFactory, "baseTraceFactory");
        return new LoggingBaseTraceFactory(baseTraceFactory);
    }

    private LoggingBaseTraceFactory(BaseTraceFactory baseTraceFactory) {
        this.baseTraceFactory = Objects.requireNonNull(baseTraceFactory, "baseTraceFactory");
    }

    @Override
    public Trace disableSampling() {
        this.logger.debug("disableSampling()");
        return this.baseTraceFactory.disableSampling();
    }

    @Override
    public Trace continueTraceObject(TraceId traceId) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("continueTraceObject(traceId:{})", (Object)traceId);
        }
        return this.baseTraceFactory.continueTraceObject(traceId);
    }

    @Override
    @InterfaceAudience.LimitedPrivate(value={"vert.x"})
    public Trace continueAsyncTraceObject(TraceId traceId) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("continueAsyncTraceObject(traceId:{})", (Object)traceId);
        }
        return this.baseTraceFactory.continueAsyncTraceObject(traceId);
    }

    @Override
    public Trace continueAsyncContextTraceObject(TraceRoot traceRoot, LocalAsyncId localAsyncId, boolean canSampled) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("continueAsyncTraceObject(traceRoot:{}, localAsyncId:{}, canSampled:{})", (Object)traceRoot, (Object)localAsyncId, (Object)canSampled);
        }
        return this.baseTraceFactory.continueAsyncContextTraceObject(traceRoot, localAsyncId, canSampled);
    }

    @Override
    public Trace newTraceObject() {
        this.logger.debug("newTraceObject()");
        return this.baseTraceFactory.newTraceObject();
    }

    @Override
    @InterfaceAudience.LimitedPrivate(value={"vert.x"})
    public Trace newAsyncTraceObject() {
        this.logger.debug("newAsyncTraceObject()");
        return this.baseTraceFactory.newAsyncTraceObject();
    }
}

