/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.annotation;

import com.navercorp.pinpoint.grpc.trace.PAnnotationValue;
import com.navercorp.pinpoint.profiler.context.Annotation;
import com.navercorp.pinpoint.profiler.context.grpc.GrpcAnnotationSerializable;
import com.navercorp.pinpoint.profiler.context.grpc.GrpcAnnotationValueMapper;
import com.navercorp.pinpoint.profiler.context.thrift.AnnotationValueThriftMapper;
import com.navercorp.pinpoint.profiler.context.thrift.ThriftAnnotationSerializable;
import com.navercorp.pinpoint.thrift.dto.TAnnotationValue;

public class DoubleAnnotation
implements Annotation<Double>,
GrpcAnnotationSerializable,
ThriftAnnotationSerializable {
    private final int key;
    private final double value;

    DoubleAnnotation(int key, double value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public int getAnnotationKey() {
        return this.getKey();
    }

    @Override
    public int getKey() {
        return this.key;
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    @Override
    public PAnnotationValue apply(GrpcAnnotationValueMapper context) {
        PAnnotationValue.Builder builder = context.getAnnotationBuilder();
        builder.setDoubleValue(this.value);
        return builder.build();
    }

    @Override
    public TAnnotationValue apply(AnnotationValueThriftMapper context) {
        return TAnnotationValue.doubleValue((double)this.value);
    }

    public String toString() {
        return "DoubleAnnotation{" + this.key + "=" + this.value + '}';
    }
}

