/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.grpc;

import com.google.protobuf.GeneratedMessageV3;
import com.navercorp.pinpoint.grpc.trace.PApiMetaData;
import com.navercorp.pinpoint.grpc.trace.PSqlMetaData;
import com.navercorp.pinpoint.grpc.trace.PStringMetaData;
import com.navercorp.pinpoint.profiler.context.thrift.MessageConverter;
import com.navercorp.pinpoint.profiler.metadata.ApiMetaData;
import com.navercorp.pinpoint.profiler.metadata.MetaDataType;
import com.navercorp.pinpoint.profiler.metadata.SqlMetaData;
import com.navercorp.pinpoint.profiler.metadata.StringMetaData;

public class GrpcMetadataMessageConverter
implements MessageConverter<MetaDataType, GeneratedMessageV3> {
    @Override
    public GeneratedMessageV3 toMessage(MetaDataType message) {
        if (message instanceof SqlMetaData) {
            SqlMetaData sqlMetaData = (SqlMetaData)message;
            return this.convertSqlMetaData(sqlMetaData);
        }
        if (message instanceof ApiMetaData) {
            ApiMetaData apiMetaData = (ApiMetaData)message;
            return this.convertApiMetaData(apiMetaData);
        }
        if (message instanceof StringMetaData) {
            StringMetaData stringMetaData = (StringMetaData)message;
            return this.convertStringMetaData(stringMetaData);
        }
        return null;
    }

    private PSqlMetaData convertSqlMetaData(SqlMetaData sqlMetaData) {
        PSqlMetaData.Builder builder = PSqlMetaData.newBuilder();
        builder.setSqlId(sqlMetaData.getSqlId());
        builder.setSql(sqlMetaData.getSql());
        return builder.build();
    }

    private PApiMetaData convertApiMetaData(ApiMetaData apiMetaData) {
        PApiMetaData.Builder builder = PApiMetaData.newBuilder();
        builder.setApiId(apiMetaData.getApiId());
        builder.setApiInfo(apiMetaData.getApiInfo());
        builder.setLine(apiMetaData.getLine());
        builder.setType(apiMetaData.getType());
        return builder.build();
    }

    private PStringMetaData convertStringMetaData(StringMetaData stringMetaData) {
        PStringMetaData.Builder builder = PStringMetaData.newBuilder();
        builder.setStringId(stringMetaData.getStringId());
        builder.setStringValue(stringMetaData.getStringValue());
        return builder.build();
    }
}

