/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.grpc;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.protobuf.GeneratedMessageV3;
import com.navercorp.pinpoint.grpc.client.ChannelFactory;
import com.navercorp.pinpoint.grpc.client.ChannelFactoryBuilder;
import com.navercorp.pinpoint.grpc.client.DefaultChannelFactoryBuilder;
import com.navercorp.pinpoint.grpc.client.HeaderFactory;
import com.navercorp.pinpoint.grpc.client.UnaryCallDeadlineInterceptor;
import com.navercorp.pinpoint.grpc.client.config.ClientOption;
import com.navercorp.pinpoint.grpc.client.config.SslOption;
import com.navercorp.pinpoint.profiler.context.grpc.config.GrpcTransportConfig;
import com.navercorp.pinpoint.profiler.context.module.StatDataSender;
import com.navercorp.pinpoint.profiler.context.thrift.MessageConverter;
import com.navercorp.pinpoint.profiler.monitor.metric.MetricType;
import com.navercorp.pinpoint.profiler.sender.DataSender;
import com.navercorp.pinpoint.profiler.sender.grpc.ReconnectExecutor;
import com.navercorp.pinpoint.profiler.sender.grpc.StatGrpcDataSender;
import io.grpc.ClientInterceptor;
import io.grpc.NameResolverProvider;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StatGrpcDataSenderProvider
implements Provider<DataSender<MetricType>> {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final GrpcTransportConfig grpcTransportConfig;
    private final MessageConverter<MetricType, GeneratedMessageV3> messageConverter;
    private final HeaderFactory headerFactory;
    private final Provider<ReconnectExecutor> reconnectExecutorProvider;
    private final NameResolverProvider nameResolverProvider;
    private List<ClientInterceptor> clientInterceptorList;

    @Inject
    public StatGrpcDataSenderProvider(GrpcTransportConfig grpcTransportConfig, @StatDataSender MessageConverter<MetricType, GeneratedMessageV3> messageConverter, HeaderFactory headerFactory, Provider<ReconnectExecutor> reconnectExecutor, NameResolverProvider nameResolverProvider) {
        this.grpcTransportConfig = Objects.requireNonNull(grpcTransportConfig, "profilerConfig");
        this.messageConverter = Objects.requireNonNull(messageConverter, "messageConverter");
        this.headerFactory = Objects.requireNonNull(headerFactory, "agentHeaderFactory");
        this.reconnectExecutorProvider = Objects.requireNonNull(reconnectExecutor, "reconnectExecutorProvider");
        this.nameResolverProvider = Objects.requireNonNull(nameResolverProvider, "nameResolverProvider");
    }

    @Inject(optional=true)
    public void setClientInterceptor(@StatDataSender List<ClientInterceptor> clientInterceptorList) {
        this.clientInterceptorList = Objects.requireNonNull(clientInterceptorList, "clientInterceptorList");
    }

    public DataSender<MetricType> get() {
        String collectorIp = this.grpcTransportConfig.getStatCollectorIp();
        int collectorPort = this.grpcTransportConfig.getStatCollectorPort();
        boolean sslEnable = this.grpcTransportConfig.isStatSslEnable();
        int senderExecutorQueueSize = this.grpcTransportConfig.getStatSenderExecutorQueueSize();
        ChannelFactoryBuilder channelFactoryBuilder = this.newChannelFactoryBuilder(sslEnable);
        ChannelFactory channelFactory = channelFactoryBuilder.build();
        ReconnectExecutor reconnectExecutor = (ReconnectExecutor)this.reconnectExecutorProvider.get();
        return new StatGrpcDataSender(collectorIp, collectorPort, senderExecutorQueueSize, this.messageConverter, reconnectExecutor, channelFactory);
    }

    private ChannelFactoryBuilder newChannelFactoryBuilder(boolean sslEnable) {
        int channelExecutorQueueSize = this.grpcTransportConfig.getStatChannelExecutorQueueSize();
        UnaryCallDeadlineInterceptor unaryCallDeadlineInterceptor = new UnaryCallDeadlineInterceptor(this.grpcTransportConfig.getStatRequestTimeout());
        ClientOption clientOption = this.grpcTransportConfig.getStatClientOption();
        DefaultChannelFactoryBuilder channelFactoryBuilder = new DefaultChannelFactoryBuilder("StatGrpcDataSender");
        channelFactoryBuilder.setHeaderFactory(this.headerFactory);
        channelFactoryBuilder.setNameResolverProvider(this.nameResolverProvider);
        channelFactoryBuilder.addClientInterceptor((ClientInterceptor)unaryCallDeadlineInterceptor);
        if (this.clientInterceptorList != null) {
            for (ClientInterceptor clientInterceptor : this.clientInterceptorList) {
                this.logger.info("addClientInterceptor:{}", (Object)clientInterceptor);
                channelFactoryBuilder.addClientInterceptor(clientInterceptor);
            }
        }
        channelFactoryBuilder.setExecutorQueueSize(channelExecutorQueueSize);
        channelFactoryBuilder.setClientOption(clientOption);
        if (sslEnable) {
            SslOption sslOption = this.grpcTransportConfig.getSslOption();
            channelFactoryBuilder.setSslOption(sslOption);
        }
        return channelFactoryBuilder;
    }
}

