/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.thrift;

import com.navercorp.pinpoint.bootstrap.context.ServerMetaData;
import com.navercorp.pinpoint.bootstrap.context.ServiceInfo;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.profiler.AgentInformation;
import com.navercorp.pinpoint.profiler.JvmInformation;
import com.navercorp.pinpoint.profiler.context.thrift.JvmGcTypeThriftMessageConverter;
import com.navercorp.pinpoint.profiler.context.thrift.MessageConverter;
import com.navercorp.pinpoint.profiler.metadata.AgentInfo;
import com.navercorp.pinpoint.profiler.metadata.ApiMetaData;
import com.navercorp.pinpoint.profiler.metadata.MetaDataType;
import com.navercorp.pinpoint.profiler.metadata.SqlMetaData;
import com.navercorp.pinpoint.profiler.metadata.StringMetaData;
import com.navercorp.pinpoint.thrift.dto.TAgentInfo;
import com.navercorp.pinpoint.thrift.dto.TApiMetaData;
import com.navercorp.pinpoint.thrift.dto.TJvmGcType;
import com.navercorp.pinpoint.thrift.dto.TJvmInfo;
import com.navercorp.pinpoint.thrift.dto.TServerMetaData;
import com.navercorp.pinpoint.thrift.dto.TServiceInfo;
import com.navercorp.pinpoint.thrift.dto.TSqlMetaData;
import com.navercorp.pinpoint.thrift.dto.TStringMetaData;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.thrift.TBase;

public class MetadataMessageConverter
implements MessageConverter<MetaDataType, TBase<?, ?>> {
    private final String applicationName;
    private final String agentId;
    private final long agentStartTime;
    private final JvmGcTypeThriftMessageConverter jvmGcTypeMessageConverter = new JvmGcTypeThriftMessageConverter();

    public MetadataMessageConverter(String applicationName, String agentId, long agentStartTime) {
        this.applicationName = Objects.requireNonNull(applicationName, "applicationName");
        this.agentId = Objects.requireNonNull(agentId, "agentId");
        this.agentStartTime = agentStartTime;
    }

    @Override
    public TBase<?, ?> toMessage(MetaDataType message) {
        if (message instanceof AgentInfo) {
            AgentInfo agentInfo = (AgentInfo)message;
            return this.convertAgentInfo(agentInfo);
        }
        if (message instanceof SqlMetaData) {
            SqlMetaData sqlMetaData = (SqlMetaData)message;
            return this.convertSqlMetaData(sqlMetaData);
        }
        if (message instanceof ApiMetaData) {
            ApiMetaData apiMetaData = (ApiMetaData)message;
            return this.convertApiMetaData(apiMetaData);
        }
        if (message instanceof StringMetaData) {
            StringMetaData stringMetaData = (StringMetaData)message;
            return this.convertStringMetaData(stringMetaData);
        }
        return null;
    }

    public TAgentInfo convertAgentInfo(AgentInfo agentInfo) {
        AgentInformation agentInformation = agentInfo.getAgentInformation();
        TAgentInfo tAgentInfo = new TAgentInfo();
        tAgentInfo.setIp(agentInformation.getHostIp());
        tAgentInfo.setHostname(agentInformation.getMachineName());
        tAgentInfo.setPorts("");
        tAgentInfo.setAgentId(agentInformation.getAgentId());
        String agentName = agentInformation.getAgentName();
        if (!StringUtils.isEmpty((String)agentName)) {
            tAgentInfo.setAgentName(agentName);
        }
        tAgentInfo.setApplicationName(agentInformation.getApplicationName());
        tAgentInfo.setContainer(agentInformation.isContainer());
        tAgentInfo.setPid(agentInformation.getPid());
        tAgentInfo.setStartTimestamp(agentInformation.getStartTime());
        tAgentInfo.setServiceType(agentInformation.getServerType().getCode());
        tAgentInfo.setVmVersion(agentInformation.getJvmVersion());
        tAgentInfo.setAgentVersion("2.4.1");
        TServerMetaData tServerMetaData = this.convertServerMetaData(agentInfo.getServerMetaData());
        tAgentInfo.setServerMetaData(tServerMetaData);
        TJvmInfo tJvmInfo = this.convertJvmInfo(agentInfo.getJvmInfo());
        tAgentInfo.setJvmInfo(tJvmInfo);
        return tAgentInfo;
    }

    private TServerMetaData convertServerMetaData(ServerMetaData serverMetaData) {
        if (serverMetaData == null) {
            return null;
        }
        TServerMetaData tServerMetaData = new TServerMetaData();
        tServerMetaData.setServerInfo(serverMetaData.getServerInfo());
        tServerMetaData.setVmArgs(serverMetaData.getVmArgs());
        ArrayList<TServiceInfo> tServiceInfos = new ArrayList<TServiceInfo>();
        for (ServiceInfo serviceInfo : serverMetaData.getServiceInfos()) {
            TServiceInfo tServiceInfo = new TServiceInfo();
            tServiceInfo.setServiceName(serviceInfo.getServiceName());
            tServiceInfo.setServiceLibs(serviceInfo.getServiceLibs());
            tServiceInfos.add(tServiceInfo);
        }
        tServerMetaData.setServiceInfos(tServiceInfos);
        return tServerMetaData;
    }

    private TJvmInfo convertJvmInfo(JvmInformation jvmInformation) {
        TJvmInfo tJvmInfo = new TJvmInfo();
        tJvmInfo.setVmVersion(jvmInformation.getJvmVersion());
        TJvmGcType gcType = this.jvmGcTypeMessageConverter.toMessage((Object)jvmInformation.getJvmGcType());
        tJvmInfo.setGcType(gcType);
        return tJvmInfo;
    }

    private TSqlMetaData convertSqlMetaData(SqlMetaData sqlMetaData) {
        return new TSqlMetaData(this.agentId, this.agentStartTime, sqlMetaData.getSqlId(), sqlMetaData.getSql());
    }

    private TApiMetaData convertApiMetaData(ApiMetaData apiMetaData) {
        TApiMetaData tApiMetaData = new TApiMetaData(this.agentId, this.agentStartTime, apiMetaData.getApiId(), apiMetaData.getApiInfo());
        tApiMetaData.setLine(apiMetaData.getLine());
        tApiMetaData.setType(apiMetaData.getType());
        return tApiMetaData;
    }

    private TStringMetaData convertStringMetaData(StringMetaData stringMetaData) {
        return new TStringMetaData(this.agentId, this.agentStartTime, stringMetaData.getStringId(), stringMetaData.getStringValue());
    }
}

