/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.thrift;

import com.navercorp.pinpoint.profiler.context.thrift.MessageConverter;
import com.navercorp.pinpoint.profiler.context.thrift.ThreadStateThriftMessageConverter;
import com.navercorp.pinpoint.profiler.monitor.metric.deadlock.MonitorInfoMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.deadlock.ThreadDumpMetricSnapshot;
import com.navercorp.pinpoint.thrift.dto.command.TMonitorInfo;
import com.navercorp.pinpoint.thrift.dto.command.TThreadDump;
import com.navercorp.pinpoint.thrift.dto.command.TThreadState;

public class ThreadDumpThriftMessageConverter
implements MessageConverter<Object, TThreadDump> {
    private final ThreadStateThriftMessageConverter threadStateMessageConverter = new ThreadStateThriftMessageConverter();

    @Override
    public TThreadDump toMessage(Object message) {
        if (message instanceof ThreadDumpMetricSnapshot) {
            ThreadDumpMetricSnapshot threadDumpMetricSnapshot = (ThreadDumpMetricSnapshot)message;
            TThreadDump threadDump = new TThreadDump();
            threadDump.setThreadName(threadDumpMetricSnapshot.getThreadName());
            threadDump.setThreadId(threadDumpMetricSnapshot.getThreadId());
            threadDump.setBlockedTime(threadDumpMetricSnapshot.getBlockedTime());
            threadDump.setBlockedCount(threadDumpMetricSnapshot.getBlockedCount());
            threadDump.setWaitedTime(threadDumpMetricSnapshot.getWaitedTime());
            threadDump.setWaitedCount(threadDumpMetricSnapshot.getWaitedCount());
            threadDump.setInNative(threadDumpMetricSnapshot.isInNative());
            threadDump.setSuspended(threadDumpMetricSnapshot.isSuspended());
            TThreadState threadState = this.threadStateMessageConverter.toMessage((Object)threadDumpMetricSnapshot.getThreadState());
            threadDump.setThreadState(threadState);
            for (String stackTrace : threadDumpMetricSnapshot.getStackTrace()) {
                threadDump.addToStackTrace(stackTrace);
            }
            for (MonitorInfoMetricSnapshot monitorInfoMetricSnapshot : threadDumpMetricSnapshot.getLockedMonitors()) {
                TMonitorInfo tMonitorInfo = new TMonitorInfo();
                tMonitorInfo.setStackDepth(monitorInfoMetricSnapshot.getStackDepth());
                tMonitorInfo.setStackFrame(monitorInfoMetricSnapshot.getStackFrame());
                threadDump.addToLockedMonitors(tMonitorInfo);
            }
            threadDump.setLockName(threadDumpMetricSnapshot.getLockName());
            threadDump.setLockOwnerId(threadDumpMetricSnapshot.getLockOwnerId());
            threadDump.setLockOwnerName(threadDumpMetricSnapshot.getLockOwnerName());
            for (String lockedSynchronizer : threadDumpMetricSnapshot.getLockedSynchronizers()) {
                threadDump.addToLockedSynchronizers(lockedSynchronizer);
            }
            return threadDump;
        }
        return null;
    }
}

