/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.monitor;

import com.navercorp.pinpoint.profiler.context.storage.UriStatStorage;
import com.navercorp.pinpoint.profiler.monitor.metric.MetricType;
import com.navercorp.pinpoint.profiler.monitor.metric.uri.AgentUriStatData;
import com.navercorp.pinpoint.profiler.sender.DataSender;
import java.io.Closeable;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UriStatCollectingJob
implements Runnable,
Closeable {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final boolean isTraceable = this.logger.isTraceEnabled();
    private final DataSender<MetricType> dataSender;
    private final UriStatStorage uriStatStorage;

    public UriStatCollectingJob(DataSender<MetricType> dataSender, UriStatStorage uriStatStorage) {
        this.dataSender = Objects.requireNonNull(dataSender, "dataSender");
        this.uriStatStorage = Objects.requireNonNull(uriStatStorage, "uriStatStorage");
    }

    @Override
    public void run() {
        AgentUriStatData agentUriStatData;
        while ((agentUriStatData = this.uriStatStorage.poll()) != null) {
            this.dataSender.send(agentUriStatData);
        }
    }

    @Override
    public void close() {
        try {
            this.uriStatStorage.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

