/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.io.request.Message;
import com.navercorp.pinpoint.profiler.context.thrift.BypassMessageConverter;
import com.navercorp.pinpoint.profiler.sender.AsyncQueueingExecutor;
import com.navercorp.pinpoint.profiler.sender.DefaultAsyncQueueingExecutorListener;
import com.navercorp.pinpoint.profiler.sender.EnhancedDataSender;
import com.navercorp.pinpoint.profiler.sender.MessageSerializer;
import com.navercorp.pinpoint.profiler.sender.RequestMessage;
import com.navercorp.pinpoint.profiler.sender.RequestMessageFactory;
import com.navercorp.pinpoint.profiler.sender.RetryMessage;
import com.navercorp.pinpoint.profiler.sender.RetryQueue;
import com.navercorp.pinpoint.profiler.sender.ThriftMessageSerializer;
import com.navercorp.pinpoint.profiler.sender.WriteFailFutureListener;
import com.navercorp.pinpoint.rpc.Future;
import com.navercorp.pinpoint.rpc.FutureListener;
import com.navercorp.pinpoint.rpc.ResponseMessage;
import com.navercorp.pinpoint.rpc.client.PinpointClient;
import com.navercorp.pinpoint.rpc.client.PinpointClientFactory;
import com.navercorp.pinpoint.rpc.client.PinpointClientReconnectEventListener;
import com.navercorp.pinpoint.rpc.util.ClientFactoryUtils;
import com.navercorp.pinpoint.rpc.util.TimerFactory;
import com.navercorp.pinpoint.thrift.dto.TResult;
import com.navercorp.pinpoint.thrift.io.HeaderTBaseDeserializer;
import com.navercorp.pinpoint.thrift.io.HeaderTBaseDeserializerFactory;
import com.navercorp.pinpoint.thrift.util.SerializationUtils;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.TBase;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;

public class TcpDataSender<T>
implements EnhancedDataSender<T> {
    private static final int DEFAULT_QUEUE_SIZE = 5120;
    private final Logger logger;
    private final PinpointClient client;
    private final Timer timer;
    private final AtomicBoolean fireState = new AtomicBoolean(false);
    private final WriteFailFutureListener writeFailFutureListener;
    private final MessageSerializer<T, byte[]> messageSerializer;
    private final RetryQueue retryQueue = new RetryQueue();
    protected final AsyncQueueingExecutor<Object> executor;

    public TcpDataSender(String name, String host, int port, PinpointClientFactory clientFactory) {
        this(name, ClientFactoryUtils.newPinpointClientProvider((String)host, (int)port, (PinpointClientFactory)clientFactory), TcpDataSender.newDefaultMessageSerializer(), 5120);
    }

    private static <V> MessageSerializer<V, byte[]> newDefaultMessageSerializer() {
        BypassMessageConverter messageConverter = new BypassMessageConverter();
        return new ThriftMessageSerializer(messageConverter);
    }

    public TcpDataSender(String name, String host, int port, PinpointClientFactory clientFactory, MessageSerializer<T, byte[]> messageSerializer) {
        this(name, ClientFactoryUtils.newPinpointClientProvider((String)host, (int)port, (PinpointClientFactory)clientFactory), messageSerializer, 5120);
    }

    public TcpDataSender(String name, String host, int port, PinpointClientFactory clientFactory, MessageSerializer<T, byte[]> messageSerializer, int queueSize) {
        this(name, ClientFactoryUtils.newPinpointClientProvider((String)host, (int)port, (PinpointClientFactory)clientFactory), messageSerializer, queueSize);
    }

    private TcpDataSender(String name, ClientFactoryUtils.PinpointClientProvider clientProvider, MessageSerializer<T, byte[]> messageSerializer, int queueSize) {
        this.logger = this.newLogger(name);
        Objects.requireNonNull(clientProvider, "clientProvider");
        this.client = clientProvider.get();
        Assert.isTrue((queueSize > 0 ? 1 : 0) != 0, (String)"queueSize must be 'queueSize > 0'");
        this.messageSerializer = Objects.requireNonNull(messageSerializer, "messageSerializer");
        this.timer = this.createTimer(name);
        this.writeFailFutureListener = new WriteFailFutureListener(this.logger, "io write fail.", clientProvider.getAddressAsString());
        String executorName = this.getExecutorName(name);
        this.executor = this.createAsyncQueueingExecutor(queueSize, executorName);
    }

    private AsyncQueueingExecutor<Object> createAsyncQueueingExecutor(int queueSize, String executorName) {
        DefaultAsyncQueueingExecutorListener<Object> listener = new DefaultAsyncQueueingExecutorListener<Object>(){

            @Override
            public void execute(Object message) {
                TcpDataSender.this.sendPacket(message);
            }
        };
        AsyncQueueingExecutor<Object> executor = new AsyncQueueingExecutor<Object>(queueSize, executorName, listener);
        return executor;
    }

    private Logger newLogger(String name) {
        String loggerName = this.getLoggerName(name);
        return LogManager.getLogger((String)loggerName);
    }

    private String getLoggerName(String name) {
        if (name == null) {
            return this.getClass().getName();
        }
        return this.getClass().getName() + "@" + name;
    }

    private String getExecutorName(String name) {
        name = StringUtils.defaultString((String)name, (String)"DEFAULT");
        return String.format("Pinpoint-TcpDataSender(%s)-Executor", name);
    }

    private Timer createTimer(String name) {
        String timerName = this.getTimerName(name);
        HashedWheelTimer timer = TimerFactory.createHashedWheelTimer((String)timerName, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS, (int)512);
        timer.start();
        return timer;
    }

    private String getTimerName(String name) {
        name = StringUtils.defaultString((String)name, (String)"DEFAULT");
        return String.format("Pinpoint-TcpDataSender(%s)-Timer", name);
    }

    @Override
    public boolean send(T data) {
        return this.executor.execute(data);
    }

    @Override
    public boolean request(T data) {
        return this.request(data, 3);
    }

    @Override
    public boolean request(T data, int retryCount) {
        RequestMessage<T> message = RequestMessageFactory.request(data, retryCount);
        return this.executor.execute(message);
    }

    @Override
    public boolean request(T data, FutureListener<ResponseMessage> listener) {
        RequestMessage<T> message = RequestMessageFactory.request(data, listener);
        return this.executor.execute(message);
    }

    public boolean isConnected() {
        return this.client.isConnected();
    }

    @Override
    public boolean addReconnectEventListener(PinpointClientReconnectEventListener eventListener) {
        return this.client.addPinpointClientReconnectEventListener(eventListener);
    }

    @Override
    public boolean removeReconnectEventListener(PinpointClientReconnectEventListener eventListener) {
        return this.client.removePinpointClientReconnectEventListener(eventListener);
    }

    @Override
    public void stop() {
        this.executor.stop();
        Set stop = this.timer.stop();
        if (!stop.isEmpty()) {
            this.logger.info("stop Timeout:{}", (Object)stop.size());
        }
        if (this.client != null) {
            this.client.close();
        }
    }

    protected void sendPacket(Object message) {
        try {
            RequestMessage requestMessage;
            if (message instanceof RequestMessage && this.doRequest(requestMessage = (RequestMessage)message)) {
                return;
            }
            byte[] copy = this.messageSerializer.serializer(message);
            if (copy == null) {
                this.logger.error("sendPacket fail. invalid dto type:{}", message.getClass());
                return;
            }
            this.doSend(copy);
        }
        catch (Exception e) {
            this.logger.warn("tcp send fail. Caused:{}", (Object)e.getMessage(), (Object)e);
        }
    }

    private boolean doRequest(RequestMessage<T> requestMessage) {
        T message = requestMessage.getMessage();
        byte[] copy = this.messageSerializer.serializer(message);
        if (copy == null) {
            return false;
        }
        FutureListener<ResponseMessage> futureListener = requestMessage.getFutureListener();
        if (futureListener != null) {
            this.doRequest(copy, futureListener);
        } else {
            int retryCount = requestMessage.getRetryCount();
            this.doRequest(copy, retryCount, message);
        }
        return true;
    }

    protected void doSend(byte[] copy) {
        Future write = this.client.sendAsync(copy);
        write.setListener((FutureListener)this.writeFailFutureListener);
    }

    private void doRequest(final byte[] requestPacket, final int maxRetryCount, final Object targetClass) {
        FutureListener<ResponseMessage> futureListener = new FutureListener<ResponseMessage>(){

            public void onComplete(Future<ResponseMessage> future) {
                if (future.isSuccess()) {
                    ResponseMessage responseMessage = (ResponseMessage)future.getResult();
                    HeaderTBaseDeserializer deserializer = HeaderTBaseDeserializerFactory.DEFAULT_FACTORY.createDeserializer();
                    TBase response = TcpDataSender.this.deserialize(deserializer, responseMessage.getMessage());
                    if (response instanceof TResult) {
                        TResult result = (TResult)response;
                        if (result.isSuccess()) {
                            TcpDataSender.this.logger.debug("result success");
                        } else {
                            TcpDataSender.this.logger.info("request fail. request:{} Caused:{}", targetClass, (Object)result.getMessage());
                            RetryMessage retryMessage = new RetryMessage(1, maxRetryCount, requestPacket, targetClass.getClass().getSimpleName());
                            TcpDataSender.this.retryRequest(retryMessage);
                        }
                    } else {
                        TcpDataSender.this.logger.warn("Invalid response:{}", (Object)response);
                    }
                } else {
                    TcpDataSender.this.logger.info("request fail. request:{} Caused:{}", targetClass, (Object)future.getCause().getMessage(), (Object)future.getCause());
                    RetryMessage retryMessage = new RetryMessage(1, maxRetryCount, requestPacket, targetClass.getClass().getSimpleName());
                    TcpDataSender.this.retryRequest(retryMessage);
                }
            }
        };
        this.doRequest(requestPacket, futureListener);
    }

    private void doRequest(final RetryMessage retryMessage) {
        FutureListener<ResponseMessage> futureListener = new FutureListener<ResponseMessage>(){

            public void onComplete(Future<ResponseMessage> future) {
                if (future.isSuccess()) {
                    ResponseMessage responseMessage;
                    HeaderTBaseDeserializer deserializer = HeaderTBaseDeserializerFactory.DEFAULT_FACTORY.createDeserializer();
                    TBase response = TcpDataSender.this.deserialize(deserializer, (responseMessage = (ResponseMessage)future.getResult()).getMessage());
                    if (response instanceof TResult) {
                        TResult result = (TResult)response;
                        if (result.isSuccess()) {
                            TcpDataSender.this.logger.debug("result success");
                        } else {
                            TcpDataSender.this.logger.info("request fail. request:{}, Caused:{}", (Object)retryMessage, (Object)result.getMessage());
                            TcpDataSender.this.retryRequest(retryMessage);
                        }
                    } else {
                        TcpDataSender.this.logger.warn("Invalid response:{}", (Object)response);
                    }
                } else {
                    TcpDataSender.this.logger.info("request fail. request:{}, caused:{}", (Object)retryMessage, (Object)future.getCause().getMessage(), (Object)future.getCause());
                    TcpDataSender.this.retryRequest(retryMessage);
                }
            }
        };
        this.doRequest(retryMessage.getBytes(), futureListener);
    }

    private TBase<?, ?> deserialize(HeaderTBaseDeserializer deserializer, byte[] message) {
        Message deserialize = SerializationUtils.deserialize((byte[])message, (HeaderTBaseDeserializer)deserializer, null);
        if (deserialize == null) {
            return null;
        }
        return (TBase)deserialize.getData();
    }

    private void retryRequest(RetryMessage retryMessage) {
        this.retryQueue.add(retryMessage);
        if (this.fireTimeout()) {
            this.timer.newTimeout(new TimerTask(){

                public void run(Timeout timeout) throws Exception {
                    while (true) {
                        RetryMessage retryMessage;
                        if ((retryMessage = TcpDataSender.this.retryQueue.get()) == null) {
                            TcpDataSender.this.fireComplete();
                            return;
                        }
                        int fail = retryMessage.fail();
                        TcpDataSender.this.doRequest(retryMessage);
                    }
                }
            }, 10000L, TimeUnit.MILLISECONDS);
        }
    }

    private void doRequest(byte[] requestPacket, FutureListener<ResponseMessage> futureListener) {
        Future response = this.client.request(requestPacket);
        response.setListener(futureListener);
    }

    private boolean fireTimeout() {
        return this.fireState.compareAndSet(false, true);
    }

    private void fireComplete() {
        this.logger.debug("fireComplete");
        this.fireState.compareAndSet(true, false);
    }

    static {
        ChannelBuffers.buffer((int)2);
    }
}

