/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.metrics.http;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.eventmesh.common.EventMeshThreadFactory;
import org.apache.eventmesh.metrics.api.MetricsRegistry;
import org.apache.eventmesh.metrics.api.model.HttpSummaryMetrics;
import org.apache.eventmesh.metrics.api.model.Metric;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPMetricsServer {
    private static final Logger log = LoggerFactory.getLogger(HTTPMetricsServer.class);
    private final transient EventMeshHTTPServer eventMeshHTTPServer;
    private final transient List<MetricsRegistry> metricsRegistries;
    private final transient HttpSummaryMetrics summaryMetrics;
    private static ScheduledExecutorService metricsSchedule = Executors.newScheduledThreadPool(2, (ThreadFactory)new EventMeshThreadFactory("eventMesh-metrics", true));

    public HTTPMetricsServer(EventMeshHTTPServer eventMeshHTTPServer, List<MetricsRegistry> metricsRegistries) {
        Objects.requireNonNull(eventMeshHTTPServer, "EventMeshHTTPServer can not be null");
        Objects.requireNonNull(metricsRegistries, "List<MetricsRegistry> can not be null");
        this.eventMeshHTTPServer = eventMeshHTTPServer;
        this.metricsRegistries = metricsRegistries;
        this.summaryMetrics = new HttpSummaryMetrics(eventMeshHTTPServer.getBatchMsgExecutor(), eventMeshHTTPServer.getSendMsgExecutor(), eventMeshHTTPServer.getPushMsgExecutor(), eventMeshHTTPServer.getHttpRetryer().getFailedQueue());
        this.init();
    }

    private void init() {
        this.metricsRegistries.forEach(MetricsRegistry::start);
        if (log.isInfoEnabled()) {
            log.info("HTTPMetricsServer initialized.");
        }
    }

    public void start() {
        this.metricsRegistries.forEach(metricsRegistry -> {
            metricsRegistry.register((Metric)this.summaryMetrics);
            if (log.isInfoEnabled()) {
                log.info("Register httpMetrics to {}", (Object)metricsRegistry.getClass().getName());
            }
        });
        metricsSchedule.scheduleAtFixedRate(() -> {
            try {
                this.summaryMetrics.snapshotHTTPTPS();
                this.summaryMetrics.snapshotSendBatchMsgTPS();
                this.summaryMetrics.snapshotSendMsgTPS();
                this.summaryMetrics.snapshotPushMsgTPS();
            }
            catch (Exception ex) {
                log.error("eventMesh snapshot tps metrics err", (Throwable)ex);
            }
        }, 0L, 1000L, TimeUnit.MILLISECONDS);
        metricsSchedule.scheduleAtFixedRate(() -> {
            try {
                this.logPrintServerMetrics(this.summaryMetrics, this.eventMeshHTTPServer);
            }
            catch (Exception ex) {
                log.error("eventMesh print metrics err", (Throwable)ex);
            }
        }, 1000L, 30000L, TimeUnit.MILLISECONDS);
        if (log.isInfoEnabled()) {
            log.info("HTTPMetricsServer started.");
        }
    }

    public void shutdown() {
        metricsSchedule.shutdown();
        this.metricsRegistries.forEach(MetricsRegistry::showdown);
        if (log.isInfoEnabled()) {
            log.info("HTTPMetricsServer shutdown.");
        }
    }

    private void logPrintServerMetrics(HttpSummaryMetrics summaryMetrics, EventMeshHTTPServer eventMeshHTTPServer) {
        if (log.isInfoEnabled()) {
            log.info("===========================================SERVER METRICS==================================================");
            log.info("maxHTTPTPS: {}, avgHTTPTPS: {}, maxHTTPCOST: {}, avgHTTPCOST: {}, avgHTTPBodyDecodeCost: {}, httpDiscard: {}", new Object[]{Float.valueOf(summaryMetrics.maxHTTPTPS()), Float.valueOf(summaryMetrics.avgHTTPTPS()), summaryMetrics.maxHTTPCost(), Float.valueOf(summaryMetrics.avgHTTPCost()), Float.valueOf(summaryMetrics.avgHTTPBodyDecodeCost()), summaryMetrics.getHttpDiscard()});
        }
        summaryMetrics.httpStatInfoClear();
        if (log.isInfoEnabled()) {
            log.info("maxBatchSendMsgTPS: {}, avgBatchSendMsgTPS: {}, sum: {}. sumFail: {}, sumFailRate: {}, discard : {}", new Object[]{Float.valueOf(summaryMetrics.maxSendBatchMsgTPS()), Float.valueOf(summaryMetrics.avgSendBatchMsgTPS()), summaryMetrics.getSendBatchMsgNumSum(), summaryMetrics.getSendBatchMsgFailNumSum(), Float.valueOf(summaryMetrics.getSendBatchMsgFailRate()), summaryMetrics.getSendBatchMsgDiscardNumSum()});
        }
        summaryMetrics.cleanSendBatchStat();
        if (log.isInfoEnabled()) {
            log.info("maxSendMsgTPS: {}, avgSendMsgTPS: {}, sum: {}, sumFail: {}, sumFailRate: {}, replyMsg: {}, replyFail: {}", new Object[]{Float.valueOf(summaryMetrics.maxSendMsgTPS()), Float.valueOf(summaryMetrics.avgSendMsgTPS()), summaryMetrics.getSendMsgNumSum(), summaryMetrics.getSendMsgFailNumSum(), Float.valueOf(summaryMetrics.getSendMsgFailRate()), summaryMetrics.getReplyMsgNumSum(), summaryMetrics.getReplyMsgFailNumSum()});
        }
        summaryMetrics.cleanSendMsgStat();
        if (log.isInfoEnabled()) {
            log.info("maxPushMsgTPS: {}, avgPushMsgTPS: {}, sum: {}, sumFail: {}, sumFailRate: {}, maxClientLatency: {}, avgClientLatency: {}", new Object[]{Float.valueOf(summaryMetrics.maxPushMsgTPS()), Float.valueOf(summaryMetrics.avgPushMsgTPS()), summaryMetrics.getHttpPushMsgNumSum(), summaryMetrics.getHttpPushFailNumSum(), Float.valueOf(summaryMetrics.getHttpPushMsgFailRate()), Float.valueOf(summaryMetrics.maxHTTPPushLatency()), Float.valueOf(summaryMetrics.avgHTTPPushLatency())});
        }
        summaryMetrics.cleanHttpPushMsgStat();
        if (log.isInfoEnabled()) {
            log.info("batchMsgQ: {}, sendMsgQ: {}, pushMsgQ: {}, httpRetryQ: {}", new Object[]{eventMeshHTTPServer.getBatchMsgExecutor().getQueue().size(), eventMeshHTTPServer.getSendMsgExecutor().getQueue().size(), eventMeshHTTPServer.getPushMsgExecutor().getQueue().size(), eventMeshHTTPServer.getHttpRetryer().size()});
        }
        if (log.isInfoEnabled()) {
            log.info("batchAvgSend2MQCost: {}, avgSend2MQCost: {}, avgReply2MQCost: {}", new Object[]{Float.valueOf(summaryMetrics.avgBatchSendMsgCost()), Float.valueOf(summaryMetrics.avgSendMsgCost()), Float.valueOf(summaryMetrics.avgReplyMsgCost())});
        }
        summaryMetrics.send2MQStatInfoClear();
    }

    public HttpSummaryMetrics getSummaryMetrics() {
        return this.summaryMetrics;
    }
}

