/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.runtime.dto;

import org.apache.felix.http.base.internal.dispatch.MultipartConfig;
import org.apache.felix.http.base.internal.handler.ServletHandler;
import org.apache.felix.http.base.internal.runtime.ServletInfo;
import org.apache.felix.http.base.internal.runtime.dto.BaseServletDTOBuilder;
import org.apache.felix.http.base.internal.runtime.dto.BuilderConstants;
import org.osgi.service.servlet.runtime.dto.BaseServletDTO;
import org.osgi.service.servlet.runtime.dto.FailedServletDTO;
import org.osgi.service.servlet.runtime.dto.ServletDTO;

public final class ServletDTOBuilder
extends BaseServletDTOBuilder {
    public static ServletDTO build(ServletHandler handler, int reason) {
        ServletDTO dto = ServletDTOBuilder.build(handler.getServletInfo(), reason);
        BaseServletDTOBuilder.fill((BaseServletDTO)dto, handler);
        return dto;
    }

    public static ServletDTO build(ServletInfo info, int reason) {
        ServletDTO dto = reason != -1 ? new FailedServletDTO() : new ServletDTO();
        BaseServletDTOBuilder.fill((BaseServletDTO)dto, info);
        if (reason != -1) {
            dto.failureReason = reason;
        }
        dto.patterns = BuilderConstants.EMPTY_STRING_ARRAY;
        MultipartConfig config = info.getMultipartConfig();
        boolean bl = dto.multipartEnabled = config != null;
        if (config != null) {
            dto.multipartFileSizeThreshold = config.multipartThreshold;
            dto.multipartLocation = config.multipartLocation;
            dto.multipartMaxFileSize = config.multipartMaxFileSize;
            dto.multipartMaxRequestSize = config.multipartMaxRequestSize;
        }
        return dto;
    }
}

