/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.workflow;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.factories.WorkflowSchedulerFactory;
import org.apache.flink.table.gateway.api.endpoint.SqlGatewayEndpointFactoryUtils;
import org.apache.flink.table.gateway.rest.SqlGatewayRestEndpointFactory;
import org.apache.flink.table.gateway.workflow.EmbeddedWorkflowScheduler;
import org.apache.flink.table.workflow.WorkflowScheduler;

@PublicEvolving
public class EmbeddedWorkflowSchedulerFactory
implements WorkflowSchedulerFactory {
    public static final String IDENTIFIER = "embedded";

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return Collections.emptySet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        return Collections.emptySet();
    }

    public WorkflowScheduler<?> createWorkflowScheduler(WorkflowSchedulerFactory.Context context) {
        Map flinkConfigMap = context.getConfiguration().toMap();
        Configuration configuration = Configuration.fromMap((Map)flinkConfigMap);
        Map<String, String> restEndpointConfigMap = SqlGatewayEndpointFactoryUtils.getEndpointConfig(configuration, "rest");
        Configuration restConfig = SqlGatewayRestEndpointFactory.rebuildRestEndpointOptions(restEndpointConfigMap, flinkConfigMap);
        return new EmbeddedWorkflowScheduler(restConfig);
    }
}

