/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.sql;

import java.util.Optional;
import org.apache.calcite.sql.SqlOperator;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;

@Internal
public interface BuiltInSqlOperator {
    public Optional<Integer> getVersion();

    public boolean isInternal();

    public String getQualifiedName();

    public static Optional<Integer> unwrapVersion(SqlOperator operator) {
        if (operator instanceof BuiltInSqlOperator) {
            BuiltInSqlOperator builtInSqlOperator = (BuiltInSqlOperator)((Object)operator);
            return builtInSqlOperator.isInternal() ? Optional.empty() : builtInSqlOperator.getVersion();
        }
        return Optional.of(1);
    }

    public static boolean unwrapIsInternal(SqlOperator operator) {
        if (operator instanceof BuiltInSqlOperator) {
            return ((BuiltInSqlOperator)((Object)operator)).isInternal();
        }
        return false;
    }

    public static String toQualifiedName(SqlOperator operator) {
        if (operator instanceof BuiltInSqlOperator) {
            BuiltInSqlOperator builtInSqlOperator = (BuiltInSqlOperator)((Object)operator);
            return builtInSqlOperator.getQualifiedName();
        }
        return BuiltInFunctionDefinition.qualifyFunctionName((String)operator.getName(), (int)1);
    }

    public static String extractNameFromQualifiedName(String qualifiedName) {
        int versionPos = qualifiedName.length() - 1;
        while (Character.isDigit(qualifiedName.charAt(versionPos))) {
            --versionPos;
        }
        return qualifiedName.substring(1, versionPos);
    }
}

