/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join;

import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.WrappingFunction;
import org.apache.flink.streaming.api.operators.KeyContext;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.NullAwareGetters;
import org.apache.flink.table.runtime.generated.JoinCondition;
import org.apache.flink.table.runtime.operators.join.NullAwareJoinHelper;

public class JoinConditionWithNullFilters
extends WrappingFunction<JoinCondition>
implements JoinCondition {
    private static final long serialVersionUID = 1L;
    private final int[] nullFilterKeys;
    private final boolean nullSafe;
    private final boolean filterAllNulls;
    private final KeyContext keyContext;

    public JoinConditionWithNullFilters(JoinCondition backingJoinCondition, boolean[] filterNullKeys, KeyContext keyContext) {
        super((Function)backingJoinCondition);
        this.nullFilterKeys = NullAwareJoinHelper.getNullFilterKeys(filterNullKeys);
        this.nullSafe = this.nullFilterKeys.length == 0;
        this.filterAllNulls = this.nullFilterKeys.length == filterNullKeys.length;
        this.keyContext = keyContext;
    }

    @Override
    public boolean apply(RowData left, RowData right) {
        if (!this.nullSafe) {
            NullAwareGetters joinKey = (NullAwareGetters)this.keyContext.getCurrentKey();
            if (this.filterAllNulls ? joinKey.anyNull() : joinKey.anyNull(this.nullFilterKeys)) {
                return false;
            }
        }
        return ((JoinCondition)this.wrappedFunction).apply(left, right);
    }
}

