/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window.groupwindow.triggers;

import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.table.runtime.operators.window.Window;
import org.apache.flink.table.runtime.operators.window.groupwindow.triggers.ElementTriggers;
import org.apache.flink.table.runtime.operators.window.groupwindow.triggers.Trigger;
import org.apache.flink.table.runtime.operators.window.groupwindow.triggers.WindowTrigger;
import org.apache.flink.util.Preconditions;

public class EventTimeTriggers {
    private static final String TO_STRING = "EventTime.afterEndOfWindow()";

    private EventTimeTriggers() {
    }

    public static <W extends Window> AfterEndOfWindow<W> afterEndOfWindow() {
        return new AfterEndOfWindow();
    }

    public static final class AfterEndOfWindowNoLate<W extends Window>
    extends WindowTrigger<W> {
        private static final long serialVersionUID = -4334481808648361926L;
        private final Trigger<W> earlyTrigger;

        public Trigger<W> withLateFirings(Trigger<W> lateFirings) {
            Preconditions.checkNotNull(lateFirings);
            if (lateFirings instanceof ElementTriggers.EveryElement) {
                return this;
            }
            return new AfterEndOfWindowEarlyAndLate<W>(this.earlyTrigger, lateFirings);
        }

        private AfterEndOfWindowNoLate(Trigger<W> earlyTrigger) {
            Preconditions.checkNotNull(earlyTrigger);
            this.earlyTrigger = earlyTrigger;
        }

        @Override
        public void open(Trigger.TriggerContext ctx) throws Exception {
            this.ctx = ctx;
            this.earlyTrigger.open(ctx);
        }

        @Override
        public boolean onElement(Object element, long timestamp, W window) throws Exception {
            if (this.triggerTime(window) <= this.ctx.getCurrentWatermark()) {
                return true;
            }
            this.ctx.registerEventTimeTimer(this.triggerTime(window));
            return this.earlyTrigger.onElement(element, timestamp, window);
        }

        @Override
        public boolean onProcessingTime(long time, W window) throws Exception {
            return this.earlyTrigger.onProcessingTime(time, window);
        }

        @Override
        public boolean onEventTime(long time, W window) throws Exception {
            return time == this.triggerTime(window) || this.earlyTrigger.onEventTime(time, window);
        }

        @Override
        public boolean canMerge() {
            return this.earlyTrigger.canMerge();
        }

        @Override
        public void onMerge(W window, Trigger.OnMergeContext mergeContext) throws Exception {
            this.ctx.registerEventTimeTimer(this.triggerTime(window));
            this.earlyTrigger.onMerge(window, mergeContext);
        }

        @Override
        public void clear(W window) throws Exception {
            this.ctx.deleteEventTimeTimer(this.triggerTime(window));
            this.earlyTrigger.clear(window);
        }

        public String toString() {
            return "EventTime.afterEndOfWindow().withEarlyFirings(" + String.valueOf(this.earlyTrigger) + ")";
        }
    }

    public static final class AfterEndOfWindowEarlyAndLate<W extends Window>
    extends WindowTrigger<W> {
        private static final long serialVersionUID = -800582945577030338L;
        private final Trigger<W> earlyTrigger;
        private final Trigger<W> lateTrigger;
        private final ValueStateDescriptor<Boolean> hasFiredOnTimeStateDesc;

        AfterEndOfWindowEarlyAndLate(Trigger<W> earlyTrigger, Trigger<W> lateTrigger) {
            this.earlyTrigger = earlyTrigger;
            this.lateTrigger = lateTrigger;
            this.hasFiredOnTimeStateDesc = new ValueStateDescriptor("eventTime-afterEOW", Types.BOOLEAN);
        }

        @Override
        public void open(Trigger.TriggerContext ctx) throws Exception {
            this.ctx = ctx;
            if (this.earlyTrigger != null) {
                this.earlyTrigger.open(ctx);
            }
            if (this.lateTrigger != null) {
                this.lateTrigger.open(ctx);
            }
        }

        @Override
        public boolean onElement(Object element, long timestamp, W window) throws Exception {
            Boolean hasFired = (Boolean)((ValueState)this.ctx.getPartitionedState(this.hasFiredOnTimeStateDesc)).value();
            if (hasFired != null && hasFired.booleanValue()) {
                return this.lateTrigger != null && this.lateTrigger.onElement(element, timestamp, window);
            }
            if (this.triggerTime(window) <= this.ctx.getCurrentWatermark()) {
                return true;
            }
            this.ctx.registerEventTimeTimer(this.triggerTime(window));
            return this.earlyTrigger != null && this.earlyTrigger.onElement(element, timestamp, window);
        }

        @Override
        public boolean onProcessingTime(long time, W window) throws Exception {
            Boolean hasFired = (Boolean)((ValueState)this.ctx.getPartitionedState(this.hasFiredOnTimeStateDesc)).value();
            if (hasFired != null && hasFired.booleanValue()) {
                return this.lateTrigger != null && this.lateTrigger.onProcessingTime(time, window);
            }
            return this.earlyTrigger != null && this.earlyTrigger.onProcessingTime(time, window);
        }

        @Override
        public boolean onEventTime(long time, W window) throws Exception {
            ValueState hasFiredState = (ValueState)this.ctx.getPartitionedState(this.hasFiredOnTimeStateDesc);
            Boolean hasFired = (Boolean)hasFiredState.value();
            if (hasFired != null && hasFired.booleanValue()) {
                return this.lateTrigger != null && this.lateTrigger.onEventTime(time, window);
            }
            if (time == this.triggerTime(window)) {
                hasFiredState.update((Object)true);
                return true;
            }
            return this.earlyTrigger != null && this.earlyTrigger.onEventTime(time, window);
        }

        @Override
        public boolean canMerge() {
            return !(this.earlyTrigger != null && !this.earlyTrigger.canMerge() || this.lateTrigger != null && !this.lateTrigger.canMerge());
        }

        @Override
        public void onMerge(W window, Trigger.OnMergeContext mergeContext) throws Exception {
            if (this.earlyTrigger != null) {
                this.earlyTrigger.onMerge(window, mergeContext);
            }
            if (this.lateTrigger != null) {
                this.lateTrigger.onMerge(window, mergeContext);
            }
            ((ValueState)this.ctx.getPartitionedState(this.hasFiredOnTimeStateDesc)).update((Object)false);
            this.ctx.registerEventTimeTimer(this.triggerTime(window));
        }

        @Override
        public void clear(W window) throws Exception {
            if (this.earlyTrigger != null) {
                this.earlyTrigger.clear(window);
            }
            if (this.lateTrigger != null) {
                this.lateTrigger.clear(window);
            }
            this.ctx.deleteEventTimeTimer(this.triggerTime(window));
            ((ValueState)this.ctx.getPartitionedState(this.hasFiredOnTimeStateDesc)).clear();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(EventTimeTriggers.TO_STRING);
            if (this.earlyTrigger != null) {
                builder.append(".withEarlyFirings(").append(this.earlyTrigger).append(")");
            }
            if (this.lateTrigger != null) {
                builder.append(".withLateFirings(").append(this.lateTrigger).append(")");
            }
            return builder.toString();
        }
    }

    public static final class AfterEndOfWindow<W extends Window>
    extends WindowTrigger<W> {
        private static final long serialVersionUID = -6379468077823588591L;

        public AfterEndOfWindowNoLate<W> withEarlyFirings(Trigger<W> earlyFirings) {
            Preconditions.checkNotNull(earlyFirings);
            return new AfterEndOfWindowNoLate<W>(earlyFirings);
        }

        public Trigger<W> withLateFirings(Trigger<W> lateFirings) {
            Preconditions.checkNotNull(lateFirings);
            if (lateFirings instanceof ElementTriggers.EveryElement) {
                return this;
            }
            return new AfterEndOfWindowEarlyAndLate<W>(null, lateFirings);
        }

        @Override
        public void open(Trigger.TriggerContext ctx) throws Exception {
            this.ctx = ctx;
        }

        @Override
        public boolean onElement(Object element, long timestamp, W window) throws Exception {
            if (this.triggerTime(window) <= this.ctx.getCurrentWatermark()) {
                return true;
            }
            this.ctx.registerEventTimeTimer(this.triggerTime(window));
            return false;
        }

        @Override
        public boolean onProcessingTime(long time, W window) throws Exception {
            return false;
        }

        @Override
        public boolean onEventTime(long time, W window) throws Exception {
            return time == this.triggerTime(window);
        }

        @Override
        public void clear(W window) throws Exception {
            this.ctx.deleteEventTimeTimer(this.triggerTime(window));
        }

        @Override
        public boolean canMerge() {
            return true;
        }

        @Override
        public void onMerge(W window, Trigger.OnMergeContext mergeContext) throws Exception {
            this.ctx.registerEventTimeTimer(this.triggerTime(window));
        }

        public String toString() {
            return EventTimeTriggers.TO_STRING;
        }
    }
}

