/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.node;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.lookup.DefaultStringLookup;
import org.apache.commons.text.lookup.StringLookup;
import org.apache.commons.text.lookup.StringLookupFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MapResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapResolver.class);
    private static final String DEFAULT_LOOKUPS = "lookups.properties";
    private static final String CUSTOM_LOOKUPS_KEY = "lookups";
    private static final String PROPS_IMPL_KEY = "propertiesImplementation";
    private static final String ENV_VAR_PROPERTY = "org.apache.flume.node.EnvVarResolverProperties";
    private static final String LOOKUP = "org.apache.commons.text.lookup.DefaultStringLookup.";
    private static final LookupEntry[] LOOKUP_ENTRIES = new LookupEntry[]{new LookupEntry("sys", DefaultStringLookup.SYSTEM_PROPERTIES.getStringLookup()), new LookupEntry("env", DefaultStringLookup.ENVIRONMENT.getStringLookup()), new LookupEntry("java", DefaultStringLookup.JAVA.getStringLookup()), new LookupEntry("date", DefaultStringLookup.DATE.getStringLookup())};

    MapResolver() {
    }

    public static Map<String, String> resolveProperties(Properties properties) {
        HashMap<String, String> map = new HashMap<String, String>();
        boolean useEnvVars = ENV_VAR_PROPERTY.equals(System.getProperty(PROPS_IMPL_KEY));
        DefaultLookup defaultLookup = useEnvVars ? new DefaultLookup(map) : StringLookupFactory.INSTANCE.mapStringLookup(map);
        StringLookup lookup = StringLookupFactory.INSTANCE.interpolatorStringLookup(MapResolver.createLookupMap(), (StringLookup)defaultLookup, false);
        StringSubstitutor substitutor = new StringSubstitutor(lookup);
        substitutor.setEnableSubstitutionInVariables(true);
        properties.stringPropertyNames().forEach(k -> map.put((String)k, substitutor.replace(properties.getProperty((String)k))));
        return map;
    }

    private static Map<String, StringLookup> createLookupMap() {
        HashMap<String, StringLookup> map = new HashMap<String, StringLookup>();
        Properties properties = MapResolver.loadProperties();
        if (properties == null) {
            Arrays.stream(LOOKUP_ENTRIES).forEach(e -> map.put(((LookupEntry)e).key, ((LookupEntry)e).lookup));
        } else {
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                String key = Objects.toString(k);
                String value = Objects.toString(v);
                if (value.startsWith(LOOKUP)) {
                    String lookupEnum = value.substring(LOOKUP.length());
                    try {
                        StringLookup stringLookup = DefaultStringLookup.valueOf((String)lookupEnum).getStringLookup();
                        map.put(key.toLowerCase(Locale.ROOT), stringLookup);
                    }
                    catch (IllegalArgumentException ex) {
                        LOGGER.warn("{} is not a DefaultStringLookup enum value, ignoring", (Object)key);
                    }
                } else {
                    try {
                        Class<?> clazz = Class.forName(Objects.toString(v));
                        if (StringLookup.class.isAssignableFrom(clazz)) {
                            StringLookup stringLookup = (StringLookup)clazz.newInstance();
                            map.put(k.toString().toLowerCase(Locale.ROOT), stringLookup);
                        } else {
                            LOGGER.warn("{} is not a StringLookup, ignoring", v);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Unable to load {} due to {}, ignoring", v, (Object)ex.getMessage());
                    }
                }
            }));
        }
        return map;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties loadProperties() {
        Throwable throwable2;
        Throwable throwable;
        InputStream inputStream;
        Properties properties = new Properties();
        String fileName = System.getProperty(CUSTOM_LOOKUPS_KEY);
        if (fileName != null) {
            try {
                inputStream = new FileInputStream(fileName);
                throwable = null;
                try {
                    properties.load(inputStream);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (inputStream != null) {
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            inputStream.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                try {
                    throwable2 = null;
                    try (InputStream inputStream2 = ClassLoader.getSystemResourceAsStream(fileName);){
                        properties.load(inputStream2);
                    }
                    catch (Throwable throwable5) {
                        throwable2 = throwable5;
                        throw throwable5;
                    }
                }
                catch (IOException ex) {
                    LOGGER.warn("Unable to load {} due to {}", (Object)fileName, (Object)ex.getMessage());
                }
            }
        }
        if (properties.size() != 0) return properties;
        try {
            inputStream = ClassLoader.getSystemResourceAsStream(DEFAULT_LOOKUPS);
            throwable = null;
            try {
                if (inputStream != null) {
                    properties.load(inputStream);
                    return properties;
                }
                throwable2 = null;
                return throwable2;
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                if (inputStream != null) {
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    private static class LookupEntry {
        private final String key;
        private final StringLookup lookup;

        public LookupEntry(String key, StringLookup lookup) {
            this.key = key;
            this.lookup = lookup;
        }
    }

    private static class DefaultLookup
    implements StringLookup {
        private final Map<String, String> properties;

        DefaultLookup(Map<String, String> properties) {
            this.properties = properties;
        }

        public String lookup(String key) {
            return this.properties.containsKey(key) ? this.properties.get(key) : System.getenv(key);
        }
    }
}

