/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store.operation;

import java.math.BigDecimal;
import org.ojalgo.access.Access2D;
import org.ojalgo.constant.BigMath;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BigFunction;
import org.ojalgo.matrix.store.operation.MatrixOperation;
import org.ojalgo.scalar.ComplexNumber;

public final class SubstituteForwards
extends MatrixOperation {
    public static final SubstituteForwards SETUP = new SubstituteForwards();
    public static int THRESHOLD = 64;

    public static void invoke(BigDecimal[] data, int structure, int firstColumn, int columnLimit, Access2D<BigDecimal> body, boolean unitDiagonal, boolean conjugated, boolean identity) {
        int tmpDiagDim = (int)Math.min(body.countRows(), body.countColumns());
        BigDecimal[] tmpBodyRow = new BigDecimal[tmpDiagDim];
        for (int i = 0; i < tmpDiagDim; ++i) {
            for (int j = 0; j <= i; ++j) {
                tmpBodyRow[j] = conjugated ? body.get(j, i) : body.get(i, j);
            }
            for (int s = firstColumn; s < columnLimit; ++s) {
                int j;
                int tmpColBaseIndex = s * structure;
                BigDecimal tmpVal = BigMath.ZERO;
                int n = j = identity ? s : 0;
                while (j < i) {
                    tmpVal = tmpVal.add(tmpBodyRow[j].multiply(data[j + tmpColBaseIndex]));
                    ++j;
                }
                tmpVal = identity ? (i == s ? BigMath.ONE.subtract(tmpVal) : tmpVal.negate()) : data[i + tmpColBaseIndex].subtract(tmpVal);
                if (!unitDiagonal) {
                    tmpVal = BigFunction.DIVIDE.invoke(tmpVal, tmpBodyRow[i]);
                }
                data[i + tmpColBaseIndex] = tmpVal;
            }
        }
    }

    public static void invoke(ComplexNumber[] data, int structure, int firstColumn, int columnLimit, Access2D<ComplexNumber> body, boolean unitDiagonal, boolean conjugated, boolean identity) {
        int tmpDiagDim = (int)Math.min(body.countRows(), body.countColumns());
        ComplexNumber[] tmpBodyRow = new ComplexNumber[tmpDiagDim];
        for (int i = 0; i < tmpDiagDim; ++i) {
            for (int j = 0; j <= i; ++j) {
                tmpBodyRow[j] = conjugated ? body.get(j, i).conjugate() : body.get(i, j);
            }
            for (int s = firstColumn; s < columnLimit; ++s) {
                int j;
                int tmpColBaseIndex = s * structure;
                ComplexNumber tmpVal = ComplexNumber.ZERO;
                int n = j = identity ? s : 0;
                while (j < i) {
                    tmpVal = tmpVal.add(tmpBodyRow[j].multiply(data[j + tmpColBaseIndex]));
                    ++j;
                }
                tmpVal = identity ? (i == s ? ComplexNumber.ONE.subtract(tmpVal) : tmpVal.negate()) : data[i + tmpColBaseIndex].subtract(tmpVal);
                if (!unitDiagonal) {
                    tmpVal = tmpVal.divide(tmpBodyRow[i]);
                }
                data[i + tmpColBaseIndex] = tmpVal;
            }
        }
    }

    public static void invoke(double[] data, int structure, int firstColumn, int columnLimit, Access2D<Double> body, boolean unitDiagonal, boolean conjugated, boolean identity) {
        int tmpDiagDim = (int)Math.min(body.countRows(), body.countColumns());
        double[] tmpBodyRow = new double[tmpDiagDim];
        for (int i = 0; i < tmpDiagDim; ++i) {
            for (int j = 0; j <= i; ++j) {
                tmpBodyRow[j] = conjugated ? body.doubleValue(j, i) : body.doubleValue(i, j);
            }
            for (int s = firstColumn; s < columnLimit; ++s) {
                int j;
                int tmpColBaseIndex = s * structure;
                double tmpVal = PrimitiveMath.ZERO;
                int n = j = identity ? s : 0;
                while (j < i) {
                    tmpVal += tmpBodyRow[j] * data[j + tmpColBaseIndex];
                    ++j;
                }
                tmpVal = identity ? (i == s ? PrimitiveMath.ONE - tmpVal : -tmpVal) : data[i + tmpColBaseIndex] - tmpVal;
                if (!unitDiagonal) {
                    tmpVal /= tmpBodyRow[i];
                }
                data[i + tmpColBaseIndex] = tmpVal;
            }
        }
    }

    private SubstituteForwards() {
    }

    @Override
    public int threshold() {
        return THRESHOLD;
    }
}

