/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.zookeeper.server.admin;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.shaded.javax.servlet.Servlet;
import org.apache.hadoop.shaded.javax.servlet.ServletException;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServlet;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.shaded.org.apache.zookeeper.common.QuorumX509Util;
import org.apache.hadoop.shaded.org.apache.zookeeper.common.X509Util;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.admin.AdminServer;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.admin.CommandResponse;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.admin.Commands;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.admin.JsonOutputter;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.admin.UnifiedConnectionFactory;
import org.apache.hadoop.shaded.org.eclipse.jetty.http.HttpVersion;
import org.apache.hadoop.shaded.org.eclipse.jetty.security.ConstraintMapping;
import org.apache.hadoop.shaded.org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.apache.hadoop.shaded.org.eclipse.jetty.server.HttpConfiguration;
import org.apache.hadoop.shaded.org.eclipse.jetty.server.HttpConnectionFactory;
import org.apache.hadoop.shaded.org.eclipse.jetty.server.SecureRequestCustomizer;
import org.apache.hadoop.shaded.org.eclipse.jetty.server.Server;
import org.apache.hadoop.shaded.org.eclipse.jetty.server.ServerConnector;
import org.apache.hadoop.shaded.org.eclipse.jetty.server.SslConnectionFactory;
import org.apache.hadoop.shaded.org.eclipse.jetty.servlet.ServletContextHandler;
import org.apache.hadoop.shaded.org.eclipse.jetty.servlet.ServletHolder;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.security.Constraint;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyAdminServer
implements AdminServer {
    static final Logger LOG = LoggerFactory.getLogger(JettyAdminServer.class);
    public static final int DEFAULT_PORT = 8080;
    public static final int DEFAULT_IDLE_TIMEOUT = 30000;
    public static final String DEFAULT_COMMAND_URL = "/commands";
    private static final String DEFAULT_ADDRESS = "0.0.0.0";
    public static final int DEFAULT_STS_MAX_AGE = 86400;
    public static final int DEFAULT_HTTP_VERSION = 11;
    private final Server server;
    private final String address;
    private final int port;
    private final int idleTimeout;
    private final String commandUrl;
    private ZooKeeperServer zkServer;

    public JettyAdminServer() throws AdminServer.AdminServerException, IOException, GeneralSecurityException {
        this(System.getProperty("zookeeper.admin.serverAddress", DEFAULT_ADDRESS), Integer.getInteger("zookeeper.admin.serverPort", 8080), Integer.getInteger("zookeeper.admin.idleTimeout", 30000), System.getProperty("zookeeper.admin.commandURL", DEFAULT_COMMAND_URL), Integer.getInteger("zookeeper.admin.httpVersion", 11), Boolean.getBoolean("zookeeper.admin.portUnification"), Boolean.getBoolean("zookeeper.admin.forceHttps"));
    }

    public JettyAdminServer(String address, int port, int timeout, String commandUrl, int httpVersion, boolean portUnification, boolean forceHttps) throws IOException, GeneralSecurityException {
        this.port = port;
        this.idleTimeout = timeout;
        this.commandUrl = commandUrl;
        this.address = address;
        this.server = new Server();
        ServerConnector connector = null;
        if (!portUnification && !forceHttps) {
            connector = new ServerConnector(this.server);
        } else {
            SecureRequestCustomizer customizer = new SecureRequestCustomizer();
            customizer.setStsMaxAge(86400L);
            customizer.setStsIncludeSubDomains(true);
            HttpConfiguration config = new HttpConfiguration();
            config.setSecureScheme("https");
            config.addCustomizer(customizer);
            try (QuorumX509Util x509Util = new QuorumX509Util();){
                String privateKeyType = System.getProperty(x509Util.getSslKeystoreTypeProperty(), "");
                String privateKeyPath = System.getProperty(x509Util.getSslKeystoreLocationProperty(), "");
                String privateKeyPassword = System.getProperty(x509Util.getSslKeystorePasswdProperty(), "");
                String certAuthType = System.getProperty(x509Util.getSslTruststoreTypeProperty(), "");
                String certAuthPath = System.getProperty(x509Util.getSslTruststoreLocationProperty(), "");
                String certAuthPassword = System.getProperty(x509Util.getSslTruststorePasswdProperty(), "");
                KeyStore keyStore = null;
                KeyStore trustStore = null;
                try {
                    keyStore = X509Util.loadKeyStore(privateKeyPath, privateKeyPassword, privateKeyType);
                    trustStore = X509Util.loadTrustStore(certAuthPath, certAuthPassword, certAuthType);
                    LOG.info("Successfully loaded private key from {}", (Object)privateKeyPath);
                    LOG.info("Successfully loaded certificate authority from {}", (Object)certAuthPath);
                }
                catch (Exception e) {
                    LOG.error("Failed to load authentication certificates for admin server.", (Throwable)e);
                    throw e;
                }
                SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
                sslContextFactory.setKeyStore(keyStore);
                sslContextFactory.setKeyStorePassword(privateKeyPassword);
                sslContextFactory.setTrustStore(trustStore);
                sslContextFactory.setTrustStorePassword(certAuthPassword);
                connector = forceHttps ? new ServerConnector(this.server, new SslConnectionFactory((SslContextFactory)sslContextFactory, HttpVersion.fromVersion((int)httpVersion).asString()), new HttpConnectionFactory(config)) : new ServerConnector(this.server, new UnifiedConnectionFactory((SslContextFactory)sslContextFactory, HttpVersion.fromVersion((int)httpVersion).asString()), new HttpConnectionFactory(config));
            }
        }
        connector.setHost(address);
        connector.setPort(port);
        connector.setIdleTimeout(this.idleTimeout);
        this.server.addConnector(connector);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/*");
        this.constrainTraceMethod(context);
        this.server.setHandler(context);
        context.addServlet(new ServletHolder((Servlet)new CommandServlet()), commandUrl + "/*");
    }

    @Override
    public void start() throws AdminServer.AdminServerException {
        try {
            this.server.start();
        }
        catch (Exception e) {
            String message = String.format("Problem starting AdminServer on address %s, port %d and command URL %s", this.address, this.port, this.commandUrl);
            throw new AdminServer.AdminServerException(message, e);
        }
        LOG.info("Started AdminServer on address {}, port {} and command URL {}", new Object[]{this.address, this.port, this.commandUrl});
    }

    @Override
    public void shutdown() throws AdminServer.AdminServerException {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            String message = String.format("Problem stopping AdminServer on address %s, port %d and command URL %s", this.address, this.port, this.commandUrl);
            throw new AdminServer.AdminServerException(message, e);
        }
    }

    @Override
    public void setZooKeeperServer(ZooKeeperServer zkServer) {
        this.zkServer = zkServer;
    }

    private List<String> commandLinks() {
        ArrayList<String> links = new ArrayList<String>();
        ArrayList<String> commands = new ArrayList<String>(Commands.getPrimaryNames());
        Collections.sort(commands);
        for (String command : commands) {
            String url = this.commandUrl + "/" + command;
            links.add(String.format("<a href=\"%s\">%s</a>", url, command));
        }
        return links;
    }

    private void constrainTraceMethod(ServletContextHandler ctxHandler) {
        Constraint c = new Constraint();
        c.setAuthenticate(true);
        ConstraintMapping cmt = new ConstraintMapping();
        cmt.setConstraint(c);
        cmt.setMethod("TRACE");
        cmt.setPathSpec("/*");
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        securityHandler.setConstraintMappings(new ConstraintMapping[]{cmt});
        ctxHandler.setSecurityHandler(securityHandler);
    }

    private class CommandServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        private CommandServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            String cmd = request.getPathInfo();
            if (cmd == null || cmd.equals("/")) {
                for (String link : JettyAdminServer.this.commandLinks()) {
                    response.getWriter().println(link);
                    response.getWriter().println("<br/>");
                }
                return;
            }
            cmd = cmd.substring(1);
            Map parameterMap = request.getParameterMap();
            HashMap<String, String> kwargs = new HashMap<String, String>();
            for (Map.Entry entry : parameterMap.entrySet()) {
                kwargs.put((String)entry.getKey(), ((String[])entry.getValue())[0]);
            }
            CommandResponse cmdResponse = Commands.runCommand(cmd, JettyAdminServer.this.zkServer, kwargs);
            JsonOutputter outputter = new JsonOutputter();
            response.setStatus(200);
            response.setContentType(outputter.getContentType());
            outputter.output(cmdResponse, response.getWriter());
        }
    }
}

