/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.nustaq.serialization.serializers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.hadoop.shaded.org.nustaq.serialization.FSTClazzInfo;
import org.apache.hadoop.shaded.org.nustaq.serialization.FSTObjectInput;
import org.apache.hadoop.shaded.org.nustaq.serialization.FSTObjectOutput;
import org.apache.hadoop.shaded.org.nustaq.serialization.serializers.FSTCollectionSerializer;
import org.apache.hadoop.shaded.org.nustaq.serialization.util.FSTUtil;

public class FSTJSonUnmodifiableCollectionSerializer
extends FSTCollectionSerializer {
    public static final Class<?> UNMODIFIABLE_COLLECTION_CLASS;
    public static final Class<?> UNMODIFIABLE_RANDOM_ACCESS_LIST_CLASS;
    public static final Class<?> UNMODIFIABLE_SET_CLASS;
    public static final Class<?> UNMODIFIABLE_LIST_CLASS;

    @Override
    public void writeObject(FSTObjectOutput out, Object toWrite, FSTClazzInfo clzInfo, FSTClazzInfo.FSTFieldInfo referencedBy, int streamPosition) throws IOException {
        out.writeObject(clzInfo.getClazz());
        Collection coll = (Collection)toWrite;
        out.writeInt(coll.size());
        Iterator iterator = coll.iterator();
        while (iterator.hasNext()) {
            out.writeObject(iterator.next());
        }
    }

    @Override
    public Object instantiate(Class objectClass, FSTObjectInput in, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo referencee, int streamPosition) throws Exception {
        Class clazz = (Class)in.readObject();
        int len = in.readInt();
        try {
            if (UNMODIFIABLE_RANDOM_ACCESS_LIST_CLASS == clazz) {
                ArrayList res = new ArrayList(len);
                this.fillArray(in, serializationInfo, referencee, streamPosition, res, len);
                return Collections.unmodifiableList(res);
            }
            if (UNMODIFIABLE_LIST_CLASS == clazz) {
                LinkedList res = new LinkedList();
                this.fillArray(in, serializationInfo, referencee, streamPosition, res, len);
                return Collections.unmodifiableList(res);
            }
            if (UNMODIFIABLE_SET_CLASS == clazz) {
                HashSet res = new HashSet(len);
                this.fillArray(in, serializationInfo, referencee, streamPosition, res, len);
                return Collections.unmodifiableSet(res);
            }
            if (UNMODIFIABLE_COLLECTION_CLASS == clazz) {
                ArrayList res = new ArrayList(len);
                this.fillArray(in, serializationInfo, referencee, streamPosition, res, len);
                return Collections.unmodifiableCollection(res);
            }
            throw new RuntimeException("unexpected class tag " + clazz);
        }
        catch (Throwable th) {
            FSTUtil.rethrow(th);
            return null;
        }
    }

    private void fillArray(FSTObjectInput in, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo referencee, int streamPosition, Object res, int len) throws ClassNotFoundException, IOException, IllegalAccessException, InstantiationException {
        in.registerObject(res, streamPosition, serializationInfo, referencee);
        Collection col = (Collection)res;
        if (col instanceof ArrayList) {
            ((ArrayList)col).ensureCapacity(len);
        }
        for (int i = 0; i < len; ++i) {
            Object o = in.readObject();
            col.add(o);
        }
    }

    static {
        UNMODIFIABLE_LIST_CLASS = Collections.unmodifiableList(new LinkedList()).getClass();
        UNMODIFIABLE_RANDOM_ACCESS_LIST_CLASS = Collections.unmodifiableList(new ArrayList()).getClass();
        UNMODIFIABLE_SET_CLASS = Collections.unmodifiableSet(Collections.emptySet()).getClass();
        UNMODIFIABLE_COLLECTION_CLASS = Collections.unmodifiableCollection(new ArrayList()).getClass();
    }
}

