/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.curator.test.TestingServer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.contract.router.SecurityConfUtil;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.resolver.FileSubclusterResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableManager;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.router.RBFConfigKeys;
import org.apache.hadoop.hdfs.server.federation.store.RouterStore;
import org.apache.hadoop.hdfs.server.federation.store.driver.StateStoreDriver;
import org.apache.hadoop.hdfs.server.federation.store.driver.impl.StateStoreZooKeeperImpl;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RemoveMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RemoveMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.UpdateMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.UpdateMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.Time;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRouterMountTableCacheRefreshSecure {
    private static final Logger LOG = LoggerFactory.getLogger(TestRouterMountTableCacheRefreshSecure.class);
    private static TestingServer curatorTestingServer;
    private static MiniRouterDFSCluster cluster;
    private static MiniRouterDFSCluster.RouterContext routerContext;
    private static MountTableManager mountTableManager;

    @BeforeClass
    public static void setUp() throws Exception {
        curatorTestingServer = new TestingServer();
        curatorTestingServer.start();
        String connectString = curatorTestingServer.getConnectString();
        int numNameservices = 2;
        Configuration conf = new RouterConfigBuilder().refreshCache().admin().rpc().heartbeat().build();
        conf.addResource(SecurityConfUtil.initSecurity());
        conf.setClass("dfs.federation.router.store.driver.class", StateStoreZooKeeperImpl.class, StateStoreDriver.class);
        conf.setClass("dfs.federation.router.file.resolver.client.class", RBFConfigKeys.FEDERATION_FILE_RESOLVER_CLIENT_CLASS_DEFAULT, FileSubclusterResolver.class);
        conf.set("hadoop.zk.address", connectString);
        conf.setBoolean("dfs.federation.router.store.enable", true);
        cluster = new MiniRouterDFSCluster(false, numNameservices, conf);
        cluster.addRouterOverrides(conf);
        cluster.startCluster(conf);
        cluster.startRouters();
        cluster.waitClusterUp();
        routerContext = cluster.getRandomRouter();
        RouterStore routerStateManager = routerContext.getRouter().getRouterStateManager();
        mountTableManager = routerContext.getAdminClient().getMountTableManager();
        FederationTestUtils.waitRouterRegistered(routerStateManager, numNameservices, 60000);
    }

    @AfterClass
    public static void destory() {
        try {
            curatorTestingServer.close();
            cluster.shutdown();
        }
        catch (IOException e) {
            LOG.error("Found error when destroy, caused by: {}", (Object)e.getMessage());
        }
    }

    @After
    public void tearDown() throws IOException {
        this.clearEntries();
    }

    private void clearEntries() throws IOException {
        List<MountTable> result = this.getMountTableEntries();
        for (MountTable mountTable : result) {
            RemoveMountTableEntryResponse removeMountTableEntry = mountTableManager.removeMountTableEntry(RemoveMountTableEntryRequest.newInstance((String)mountTable.getSourcePath()));
            Assert.assertTrue((boolean)removeMountTableEntry.getStatus());
        }
    }

    @Test
    public void testMountTableEntriesCacheUpdatedAfterAddAPICall() throws IOException {
        String srcPath = "/addPath";
        MountTable newEntry = MountTable.newInstance((String)srcPath, Collections.singletonMap("ns0", "/addPathDest"), (long)Time.now(), (long)Time.now());
        this.addMountTableEntry(mountTableManager, newEntry);
        List<MiniRouterDFSCluster.RouterContext> routers = this.getRouters();
        for (MiniRouterDFSCluster.RouterContext rc : routers) {
            List<MountTable> result = this.getMountTableEntries(rc.getAdminClient().getMountTableManager());
            Assert.assertEquals((long)1L, (long)result.size());
            MountTable mountTableResult = result.get(0);
            Assert.assertEquals((Object)srcPath, (Object)mountTableResult.getSourcePath());
        }
    }

    @Test
    public void testMountTableEntriesCacheUpdatedAfterRemoveAPICall() throws IOException {
        String srcPath = "/removePathSrc";
        MountTable newEntry = MountTable.newInstance((String)srcPath, Collections.singletonMap("ns0", "/removePathDest"), (long)Time.now(), (long)Time.now());
        this.addMountTableEntry(mountTableManager, newEntry);
        List<MiniRouterDFSCluster.RouterContext> routers = this.getRouters();
        for (MiniRouterDFSCluster.RouterContext rc : routers) {
            List<MountTable> result = this.getMountTableEntries(rc.getAdminClient().getMountTableManager());
            Assert.assertEquals((long)1L, (long)result.size());
            MountTable mountTableResult = result.get(0);
            Assert.assertEquals((Object)srcPath, (Object)mountTableResult.getSourcePath());
        }
        RemoveMountTableEntryResponse removeMountTableEntry = mountTableManager.removeMountTableEntry(RemoveMountTableEntryRequest.newInstance((String)srcPath));
        Assert.assertTrue((boolean)removeMountTableEntry.getStatus());
        routers = this.getRouters();
        for (MiniRouterDFSCluster.RouterContext rc : routers) {
            List<MountTable> result = this.getMountTableEntries(rc.getAdminClient().getMountTableManager());
            Assert.assertEquals((long)0L, (long)result.size());
        }
    }

    @Test
    public void testMountTableEntriesCacheUpdatedAfterUpdateAPICall() throws IOException {
        String srcPath = "/updatePathSrc";
        String dstPath = "/updatePathDest";
        String nameServiceId = "ns0";
        MountTable newEntry = MountTable.newInstance((String)srcPath, Collections.singletonMap("ns0", "/updatePathDest"), (long)Time.now(), (long)Time.now());
        this.addMountTableEntry(mountTableManager, newEntry);
        List<MiniRouterDFSCluster.RouterContext> routers = this.getRouters();
        for (MiniRouterDFSCluster.RouterContext rc : routers) {
            List<MountTable> result = this.getMountTableEntries(rc.getAdminClient().getMountTableManager());
            Assert.assertEquals((long)1L, (long)result.size());
            MountTable mountTableResult = result.get(0);
            Assert.assertEquals((Object)srcPath, (Object)mountTableResult.getSourcePath());
            Assert.assertEquals((Object)nameServiceId, (Object)((RemoteLocation)mountTableResult.getDestinations().get(0)).getNameserviceId());
            Assert.assertEquals((Object)dstPath, (Object)((RemoteLocation)mountTableResult.getDestinations().get(0)).getDest());
        }
        String key = "ns1";
        String value = "/updatePathDest2";
        MountTable upateEntry = MountTable.newInstance((String)srcPath, Collections.singletonMap(key, value), (long)Time.now(), (long)Time.now());
        UpdateMountTableEntryResponse updateMountTableEntry = mountTableManager.updateMountTableEntry(UpdateMountTableEntryRequest.newInstance((MountTable)upateEntry));
        Assert.assertTrue((boolean)updateMountTableEntry.getStatus());
        MountTable updatedMountTable = this.getMountTableEntry(srcPath);
        Assert.assertNotNull((String)"Updated mount table entrty cannot be null", (Object)updatedMountTable);
        routers = this.getRouters();
        for (MiniRouterDFSCluster.RouterContext rc : routers) {
            List<MountTable> result = this.getMountTableEntries(rc.getAdminClient().getMountTableManager());
            Assert.assertEquals((long)1L, (long)result.size());
            MountTable mountTableResult = result.get(0);
            Assert.assertEquals((Object)srcPath, (Object)mountTableResult.getSourcePath());
            Assert.assertEquals((Object)key, (Object)((RemoteLocation)updatedMountTable.getDestinations().get(0)).getNameserviceId());
            Assert.assertEquals((Object)value, (Object)((RemoteLocation)updatedMountTable.getDestinations().get(0)).getDest());
        }
    }

    @Test
    public void testCachedRouterClientBehaviourAfterRouterStoped() throws IOException {
        List<MountTable> result;
        String srcPath = "/addPathClientCache";
        MountTable newEntry = MountTable.newInstance((String)srcPath, Collections.singletonMap("ns0", "/addPathClientCacheDest"), (long)Time.now(), (long)Time.now());
        this.addMountTableEntry(mountTableManager, newEntry);
        List<MiniRouterDFSCluster.RouterContext> routers = this.getRouters();
        for (MiniRouterDFSCluster.RouterContext rc : routers) {
            result = this.getMountTableEntries(rc.getAdminClient().getMountTableManager());
            Assert.assertEquals((long)1L, (long)result.size());
            MountTable mountTableResult = result.get(0);
            Assert.assertEquals((Object)srcPath, (Object)mountTableResult.getSourcePath());
        }
        for (MiniRouterDFSCluster.RouterContext rc : routers) {
            InetSocketAddress adminServerAddress = rc.getRouter().getAdminServerAddress();
            if (routerContext.getRouter().getAdminServerAddress().equals(adminServerAddress)) continue;
            cluster.stopRouter(rc);
            break;
        }
        srcPath = "/addPathClientCache2";
        newEntry = MountTable.newInstance((String)srcPath, Collections.singletonMap("ns0", "/addPathClientCacheDest2"), (long)Time.now(), (long)Time.now());
        this.addMountTableEntry(mountTableManager, newEntry);
        for (MiniRouterDFSCluster.RouterContext rc : this.getRouters()) {
            result = this.getMountTableEntries(rc.getAdminClient().getMountTableManager());
            Assert.assertEquals((long)2L, (long)result.size());
        }
    }

    private List<MiniRouterDFSCluster.RouterContext> getRouters() {
        ArrayList<MiniRouterDFSCluster.RouterContext> result = new ArrayList<MiniRouterDFSCluster.RouterContext>();
        for (MiniRouterDFSCluster.RouterContext rc : cluster.getRouters()) {
            if (rc.getRouter().getServiceState() != Service.STATE.STARTED) continue;
            result.add(rc);
        }
        return result;
    }

    private MountTable getMountTableEntry(String srcPath) throws IOException {
        List<MountTable> mountTableEntries = this.getMountTableEntries();
        for (MountTable mountTable : mountTableEntries) {
            String sourcePath = mountTable.getSourcePath();
            if (!srcPath.equals(sourcePath)) continue;
            return mountTable;
        }
        return null;
    }

    private void addMountTableEntry(MountTableManager mountTableMgr, MountTable newEntry) throws IOException {
        AddMountTableEntryRequest addRequest = AddMountTableEntryRequest.newInstance((MountTable)newEntry);
        AddMountTableEntryResponse addResponse = mountTableMgr.addMountTableEntry(addRequest);
        Assert.assertTrue((boolean)addResponse.getStatus());
    }

    private List<MountTable> getMountTableEntries() throws IOException {
        return this.getMountTableEntries(mountTableManager);
    }

    private List<MountTable> getMountTableEntries(MountTableManager mountTableManagerParam) throws IOException {
        GetMountTableEntriesRequest request = GetMountTableEntriesRequest.newInstance((String)"/");
        return mountTableManagerParam.getMountTableEntries(request).getEntries();
    }
}

