/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterFsck;
import org.apache.hadoop.hdfs.server.federation.router.RouterHttpServer;
import org.apache.hadoop.hdfs.server.namenode.DfsServlet;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Private
public class RouterFsckServlet
extends DfsServlet {
    private static final long serialVersionUID = 1L;
    public static final String SERVLET_NAME = "fsck";
    public static final String PATH_SPEC = "/fsck";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map pmap = request.getParameterMap();
        PrintWriter out = response.getWriter();
        InetAddress remoteAddress = InetAddress.getByName(request.getRemoteAddr());
        ServletContext context = this.getServletContext();
        Configuration conf = RouterHttpServer.getConfFromContext(context);
        UserGroupInformation ugi = this.getUGI(request, conf);
        try {
            ugi.doAs(() -> {
                Router router = RouterHttpServer.getRouterFromContext(context);
                new RouterFsck(router, pmap, out, remoteAddress).fsck();
                return null;
            });
        }
        catch (InterruptedException e) {
            response.sendError(400, e.getMessage());
        }
    }
}

