/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.erasurecode.CodecUtil;
import org.apache.hadoop.io.erasurecode.ErasureCodeNative;
import org.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import org.apache.hadoop.io.erasurecode.rawcoder.NativeRSRawDecoder;
import org.apache.hadoop.io.erasurecode.rawcoder.NativeRSRawEncoder;
import org.apache.hadoop.io.erasurecode.rawcoder.NativeXORRawDecoder;
import org.apache.hadoop.io.erasurecode.rawcoder.NativeXORRawEncoder;
import org.apache.hadoop.io.erasurecode.rawcoder.RSLegacyRawDecoder;
import org.apache.hadoop.io.erasurecode.rawcoder.RSLegacyRawEncoder;
import org.apache.hadoop.io.erasurecode.rawcoder.RSRawDecoder;
import org.apache.hadoop.io.erasurecode.rawcoder.RSRawEncoder;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureDecoder;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureEncoder;
import org.apache.hadoop.io.erasurecode.rawcoder.XORRawDecoder;
import org.apache.hadoop.io.erasurecode.rawcoder.XORRawEncoder;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class TestCodecRawCoderMapping {
    private static Configuration conf;
    private static final int numDataUnit = 6;
    private static final int numParityUnit = 3;

    @Before
    public void setup() {
        conf = new Configuration();
    }

    @Test
    public void testRSDefaultRawCoder() {
        ErasureCoderOptions coderOptions = new ErasureCoderOptions(6, 3);
        RawErasureEncoder encoder = CodecUtil.createRawEncoder((Configuration)conf, (String)"rs", (ErasureCoderOptions)coderOptions);
        RawErasureDecoder decoder = CodecUtil.createRawDecoder((Configuration)conf, (String)"rs", (ErasureCoderOptions)coderOptions);
        if (ErasureCodeNative.isNativeCodeLoaded()) {
            Assert.assertTrue((boolean)(encoder instanceof NativeRSRawEncoder));
            Assert.assertTrue((boolean)(decoder instanceof NativeRSRawDecoder));
        } else {
            Assert.assertTrue((boolean)(encoder instanceof RSRawEncoder));
            Assert.assertTrue((boolean)(decoder instanceof RSRawDecoder));
        }
        encoder = CodecUtil.createRawEncoder((Configuration)conf, (String)"rs-legacy", (ErasureCoderOptions)coderOptions);
        Assert.assertTrue((boolean)(encoder instanceof RSLegacyRawEncoder));
        decoder = CodecUtil.createRawDecoder((Configuration)conf, (String)"rs-legacy", (ErasureCoderOptions)coderOptions);
        Assert.assertTrue((boolean)(decoder instanceof RSLegacyRawDecoder));
    }

    @Test
    public void testDedicatedRawCoderKey() {
        ErasureCoderOptions coderOptions = new ErasureCoderOptions(6, 3);
        String dummyFactName = "DummyNoneExistingFactory";
        conf.set("io.erasurecode.codec.rs.rawcoders", dummyFactName);
        try {
            CodecUtil.createRawEncoder((Configuration)conf, (String)"rs", (ErasureCoderOptions)coderOptions);
            Assert.fail();
        }
        catch (Exception e) {
            GenericTestUtils.assertExceptionContains("Fail to create raw erasure encoder with given codec: rs", e);
        }
        conf.set("io.erasurecode.codec.rs-legacy.rawcoders", dummyFactName);
        try {
            CodecUtil.createRawEncoder((Configuration)conf, (String)"rs-legacy", (ErasureCoderOptions)coderOptions);
            Assert.fail();
        }
        catch (Exception e) {
            GenericTestUtils.assertExceptionContains("Fail to create raw erasure encoder with given codec: rs", e);
        }
    }

    @Test
    public void testFallbackCoders() {
        ErasureCoderOptions coderOptions = new ErasureCoderOptions(6, 3);
        conf.set("io.erasurecode.codec.rs.rawcoders", "rs_java,rs_native");
        RawErasureEncoder encoder = CodecUtil.createRawEncoder((Configuration)conf, (String)"rs", (ErasureCoderOptions)coderOptions);
        Assert.assertTrue((boolean)(encoder instanceof RSRawEncoder));
        RawErasureDecoder decoder = CodecUtil.createRawDecoder((Configuration)conf, (String)"rs", (ErasureCoderOptions)coderOptions);
        Assert.assertTrue((boolean)(decoder instanceof RSRawDecoder));
    }

    @Test
    public void testLegacyCodecFallback() {
        ErasureCoderOptions coderOptions = new ErasureCoderOptions(6, 3);
        RawErasureEncoder encoder = CodecUtil.createRawEncoder((Configuration)conf, (String)"rs-legacy", (ErasureCoderOptions)coderOptions);
        Assert.assertTrue((boolean)(encoder instanceof RSLegacyRawEncoder));
        RawErasureDecoder decoder = CodecUtil.createRawDecoder((Configuration)conf, (String)"rs-legacy", (ErasureCoderOptions)coderOptions);
        Assert.assertTrue((boolean)(decoder instanceof RSLegacyRawDecoder));
    }

    @Test
    public void testIgnoreInvalidCodec() {
        ErasureCoderOptions coderOptions = new ErasureCoderOptions(6, 3);
        conf.set("io.erasurecode.codec.xor.rawcoders", "invalid-codec,xor_java");
        RawErasureEncoder encoder = CodecUtil.createRawEncoder((Configuration)conf, (String)"xor", (ErasureCoderOptions)coderOptions);
        Assert.assertTrue((boolean)(encoder instanceof XORRawEncoder));
        RawErasureDecoder decoder = CodecUtil.createRawDecoder((Configuration)conf, (String)"xor", (ErasureCoderOptions)coderOptions);
        Assert.assertTrue((boolean)(decoder instanceof XORRawDecoder));
    }

    @Test
    public void testCodecNativeEnabled() {
        Assume.assumeTrue((boolean)ErasureCodeNative.isNativeCodeLoaded());
        ErasureCoderOptions coderOptions = new ErasureCoderOptions(6, 3);
        RawErasureEncoder rsEncoder = CodecUtil.createRawEncoder((Configuration)conf, (String)"rs", (ErasureCoderOptions)coderOptions);
        RawErasureDecoder rsDecoder = CodecUtil.createRawDecoder((Configuration)conf, (String)"rs", (ErasureCoderOptions)coderOptions);
        RawErasureEncoder xorEncoder = CodecUtil.createRawEncoder((Configuration)conf, (String)"xor", (ErasureCoderOptions)coderOptions);
        RawErasureDecoder xorDecoder = CodecUtil.createRawDecoder((Configuration)conf, (String)"xor", (ErasureCoderOptions)coderOptions);
        Assert.assertTrue((boolean)(rsEncoder instanceof NativeRSRawEncoder));
        Assert.assertTrue((boolean)(rsDecoder instanceof NativeRSRawDecoder));
        Assert.assertTrue((boolean)(xorEncoder instanceof NativeXORRawEncoder));
        Assert.assertTrue((boolean)(xorDecoder instanceof NativeXORRawDecoder));
        conf.setBoolean("io.erasurecode.codec.native.enabled", false);
        rsEncoder = CodecUtil.createRawEncoder((Configuration)conf, (String)"rs", (ErasureCoderOptions)coderOptions);
        rsDecoder = CodecUtil.createRawDecoder((Configuration)conf, (String)"rs", (ErasureCoderOptions)coderOptions);
        xorEncoder = CodecUtil.createRawEncoder((Configuration)conf, (String)"xor", (ErasureCoderOptions)coderOptions);
        xorDecoder = CodecUtil.createRawDecoder((Configuration)conf, (String)"xor", (ErasureCoderOptions)coderOptions);
        Assert.assertTrue((boolean)(rsEncoder instanceof RSRawEncoder));
        Assert.assertTrue((boolean)(rsDecoder instanceof RSRawDecoder));
        Assert.assertTrue((boolean)(xorEncoder instanceof XORRawEncoder));
        Assert.assertTrue((boolean)(xorDecoder instanceof XORRawDecoder));
    }
}

