/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.api.impl.pb.client;

import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import javax.net.SocketFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.proto.YarnServerCommonServiceProtos;
import org.apache.hadoop.yarn.server.api.CollectorNodemanagerProtocol;
import org.apache.hadoop.yarn.server.api.CollectorNodemanagerProtocolPB;
import org.apache.hadoop.yarn.server.api.protocolrecords.GetTimelineCollectorContextRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.GetTimelineCollectorContextResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.ReportNewCollectorInfoRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.ReportNewCollectorInfoResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.GetTimelineCollectorContextRequestPBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.GetTimelineCollectorContextResponsePBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.ReportNewCollectorInfoRequestPBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.ReportNewCollectorInfoResponsePBImpl;

public class CollectorNodemanagerProtocolPBClientImpl
implements CollectorNodemanagerProtocol,
Closeable {
    static final String NM_COMMAND_TIMEOUT = "yarn.rpc.nm-command-timeout";
    static final int DEFAULT_COMMAND_TIMEOUT = 60000;
    private CollectorNodemanagerProtocolPB proxy;

    @InterfaceAudience.Private
    public CollectorNodemanagerProtocolPBClientImpl(long clientVersion, InetSocketAddress addr, Configuration conf) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, CollectorNodemanagerProtocolPB.class, ProtobufRpcEngine.class);
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        int expireIntvl = conf.getInt(NM_COMMAND_TIMEOUT, 60000);
        this.proxy = (CollectorNodemanagerProtocolPB)RPC.getProxy(CollectorNodemanagerProtocolPB.class, (long)clientVersion, (InetSocketAddress)addr, (UserGroupInformation)ugi, (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf), (int)expireIntvl);
    }

    @Override
    public ReportNewCollectorInfoResponse reportNewCollectorInfo(ReportNewCollectorInfoRequest request) throws YarnException, IOException {
        YarnServerCommonServiceProtos.ReportNewCollectorInfoRequestProto requestProto = ((ReportNewCollectorInfoRequestPBImpl)request).getProto();
        try {
            return new ReportNewCollectorInfoResponsePBImpl(this.proxy.reportNewCollectorInfo(null, requestProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException((ServiceException)e);
            return null;
        }
    }

    @Override
    public GetTimelineCollectorContextResponse getTimelineCollectorContext(GetTimelineCollectorContextRequest request) throws YarnException, IOException {
        YarnServerCommonServiceProtos.GetTimelineCollectorContextRequestProto requestProto = ((GetTimelineCollectorContextRequestPBImpl)request).getProto();
        try {
            return new GetTimelineCollectorContextResponsePBImpl(this.proxy.getTimelineCollectorContext(null, requestProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException((ServiceException)e);
            return null;
        }
    }

    @Override
    public void close() {
        if (this.proxy != null) {
            RPC.stopProxy((Object)this.proxy);
        }
    }
}

